/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.concurrent;

import org.apache.cassandra.utils.Shared;
import org.apache.cassandra.utils.concurrent.Awaitable;

@Shared(scope={Shared.Scope.SIMULATION})
public interface Condition
extends Awaitable {
    public boolean isSignalled();

    public void signal();

    default public void signalAll() {
        this.signal();
    }

    public static Condition newOneTimeCondition() {
        return new Async();
    }

    public static class Sync
    extends Awaitable.SyncAwaitable
    implements Condition {
        private boolean signaled = false;

        @Override
        public synchronized boolean isSignalled() {
            return this.signaled;
        }

        @Override
        public synchronized void signal() {
            this.signaled = true;
            this.notifyAll();
        }
    }

    public static class Async
    extends Awaitable.AsyncAwaitable
    implements Condition {
        private volatile boolean signaled = false;

        protected Async() {
        }

        @Override
        public boolean isSignalled() {
            return this.signaled;
        }

        @Override
        public void signal() {
            this.signaled = true;
            super.signal();
        }
    }
}

