/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.concurrenttrees.radix.node.concrete.bytearray;

import com.googlecode.concurrenttrees.common.CharSequences;

public class ByteArrayCharSequence
implements CharSequence {
    final byte[] bytes;
    final int start;
    final int end;

    public ByteArrayCharSequence(byte[] bytes, int start, int end) {
        if (start < 0) {
            throw new IllegalArgumentException("start " + start + " < 0");
        }
        if (end > bytes.length) {
            throw new IllegalArgumentException("end " + end + " > length " + bytes.length);
        }
        if (end < start) {
            throw new IllegalArgumentException("end " + end + " < start " + start);
        }
        this.bytes = bytes;
        this.start = start;
        this.end = end;
    }

    @Override
    public int length() {
        return this.end - this.start;
    }

    @Override
    public char charAt(int index) {
        return (char)(this.bytes[index + this.start] & 0xFF);
    }

    @Override
    public ByteArrayCharSequence subSequence(int start, int end) {
        if (start < 0) {
            throw new IllegalArgumentException("start " + start + " < 0");
        }
        if (end > this.length()) {
            throw new IllegalArgumentException("end " + end + " > length " + this.length());
        }
        if (end < start) {
            throw new IllegalArgumentException("end " + end + " < start " + start);
        }
        return new ByteArrayCharSequence(this.bytes, this.start + start, this.start + end);
    }

    @Override
    public String toString() {
        return CharSequences.toString(this);
    }

    public static byte[] toSingleByteUtf8Encoding(CharSequence charSequence) {
        int length = charSequence.length();
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            char inputChar = charSequence.charAt(i);
            if (inputChar > '\u00ff') {
                throw new IncompatibleCharacterException("Input contains a character which cannot be represented as a single byte in UTF-8: " + inputChar);
            }
            bytes[i] = (byte)inputChar;
        }
        return bytes;
    }

    public static class IncompatibleCharacterException
    extends IllegalStateException {
        public IncompatibleCharacterException(String s) {
            super(s);
        }
    }
}

