/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.lab.jvm.attach;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gridkit.lab.jvm.attach.JavaProcessDetails;
import org.gridkit.lab.jvm.attach.JavaProcessMatcher;

public class PatternJvmMatcher
implements JavaProcessMatcher,
Serializable {
    private static final long serialVersionUID = 20121106L;
    private final Map<String, Pattern> patterns = new LinkedHashMap<String, Pattern>();

    public void matchVmName(String pattern) {
        this.matchProp(":name", pattern);
    }

    public void matchProp(String prop, String pattern) {
        Pattern p = Pattern.compile(pattern);
        this.patterns.put(prop, p);
    }

    public void matchPropExact(String prop, String pattern) {
        this.matchProp(prop, Pattern.quote(pattern));
    }

    @Override
    public boolean evaluate(JavaProcessDetails proc) {
        if (this.patterns.containsKey(":name") && !this.match(":name", proc.getDescription())) {
            return false;
        }
        Properties props = proc.getSystemProperties();
        if (props == null) {
            return false;
        }
        for (String prop : this.patterns.keySet()) {
            if (prop.startsWith(":") || this.match(prop, props.getProperty(prop))) continue;
            return false;
        }
        return true;
    }

    private boolean match(String prop, String value) {
        if (value == null) {
            return false;
        }
        Matcher matcher = this.patterns.get(prop).matcher(value);
        return matcher.matches();
    }

    public String toString() {
        return String.format("%s%s", this.getClass().getSimpleName(), this.patterns.toString());
    }
}

