/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.EndPoint;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.TranslatedAddressEndPoint;
import java.net.InetAddress;

public class MetricsUtil {
    public static String hostMetricName(String prefix, Host host) {
        EndPoint endPoint = host.getEndPoint();
        if (endPoint instanceof TranslatedAddressEndPoint) {
            InetAddress address = endPoint.resolve().getAddress();
            return MetricsUtil.hostMetricNameFromAddress(prefix, address);
        }
        return prefix + endPoint.toString();
    }

    private static String hostMetricNameFromAddress(String prefix, InetAddress address) {
        StringBuilder result = new StringBuilder(prefix);
        boolean first = true;
        for (byte b : address.getAddress()) {
            if (first) {
                first = false;
            } else {
                result.append('_');
            }
            result.append(b & 0xFF);
        }
        return result.toString();
    }
}

