/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import net.openhft.chronicle.bytes.NoBytesStore;
import net.openhft.chronicle.bytes.StreamingDataOutput;
import net.openhft.chronicle.core.annotation.NonNegative;
import org.jetbrains.annotations.NotNull;

public class StreamingOutputStream
extends OutputStream {
    private StreamingDataOutput sdo;

    public StreamingOutputStream() {
        this(NoBytesStore.NO_BYTES);
    }

    public StreamingOutputStream(StreamingDataOutput sdo) {
        this.sdo = sdo;
    }

    @NotNull
    public StreamingOutputStream init(StreamingDataOutput sdo) {
        this.sdo = sdo;
        return this;
    }

    @Override
    public void write(byte[] b, @NonNegative int off, @NonNegative int len) throws IOException {
        try {
            this.sdo.write(b, off, len);
        }
        catch (IllegalArgumentException | IllegalStateException | BufferOverflowException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void write(int b) throws IOException {
        try {
            this.sdo.writeUnsignedByte(0xFF & b);
        }
        catch (ArithmeticException | IllegalStateException | BufferOverflowException e) {
            throw new IOException(e);
        }
    }
}

