/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.fqltool;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.cassandra.fqltool.FQLQuery;
import org.apache.cassandra.fqltool.MismatchListener;
import org.apache.cassandra.fqltool.ResultHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultComparator {
    private static final Logger logger = LoggerFactory.getLogger(ResultComparator.class);
    private final MismatchListener mismatchListener;

    public ResultComparator() {
        this(null);
    }

    public ResultComparator(MismatchListener mismatchListener) {
        this.mismatchListener = mismatchListener;
    }

    public boolean compareRows(List<String> targetHosts, FQLQuery query, List<ResultHandler.ComparableRow> rows) {
        if (rows.size() < 2 || rows.stream().allMatch(Objects::isNull)) {
            return true;
        }
        if (rows.stream().anyMatch(Objects::isNull)) {
            this.handleMismatch(targetHosts, query, rows);
            return false;
        }
        ResultHandler.ComparableRow ref = rows.get(0);
        boolean equal = true;
        for (int i = 1; i < rows.size(); ++i) {
            ResultHandler.ComparableRow compare = rows.get(i);
            if (ref.equals(compare)) continue;
            equal = false;
        }
        if (!equal) {
            this.handleMismatch(targetHosts, query, rows);
        }
        return equal;
    }

    public boolean compareColumnDefinitions(List<String> targetHosts, FQLQuery query, List<ResultHandler.ComparableColumnDefinitions> cds) {
        if (cds.size() < 2) {
            return true;
        }
        boolean equal = true;
        List<ResultHandler.ComparableDefinition> refDefs = cds.get(0).asList();
        for (int i = 1; i < cds.size(); ++i) {
            List<ResultHandler.ComparableDefinition> toCompare = cds.get(i).asList();
            if (refDefs.equals(toCompare)) continue;
            equal = false;
        }
        if (!equal) {
            this.handleColumnDefMismatch(targetHosts, query, cds);
        }
        return equal;
    }

    private void handleMismatch(List<String> targetHosts, FQLQuery query, List<ResultHandler.ComparableRow> rows) {
        UUID mismatchUUID = UUID.randomUUID();
        StringBuilder sb = new StringBuilder("{} - MISMATCH Query = {} ");
        for (int i = 0; i < targetHosts.size(); ++i) {
            sb.append("mismatch").append(i).append('=').append('\"').append(targetHosts.get(i)).append(':').append(rows.get(i)).append('\"').append(',');
        }
        logger.warn(sb.toString(), (Object)mismatchUUID, (Object)query);
        try {
            if (this.mismatchListener != null) {
                this.mismatchListener.mismatch(mismatchUUID, targetHosts, query, rows);
            }
        }
        catch (Throwable t) {
            logger.error("ERROR notifying listener", t);
        }
    }

    private void handleColumnDefMismatch(List<String> targetHosts, FQLQuery query, List<ResultHandler.ComparableColumnDefinitions> cds) {
        UUID mismatchUUID = UUID.randomUUID();
        StringBuilder sb = new StringBuilder("{} - COLUMN DEFINITION MISMATCH Query = {} ");
        for (int i = 0; i < targetHosts.size(); ++i) {
            sb.append("mismatch").append(i).append('=').append('\"').append(targetHosts.get(i)).append(':').append(this.columnDefinitionsString(cds.get(i))).append('\"').append(',');
        }
        logger.warn(sb.toString(), (Object)mismatchUUID, (Object)query);
        try {
            if (this.mismatchListener != null) {
                this.mismatchListener.columnDefMismatch(mismatchUUID, targetHosts, query, cds);
            }
        }
        catch (Throwable t) {
            logger.error("ERROR notifying listener", t);
        }
    }

    private String columnDefinitionsString(ResultHandler.ComparableColumnDefinitions cd) {
        StringBuilder sb = new StringBuilder();
        if (cd == null) {
            sb.append("NULL");
        } else if (cd.wasFailed()) {
            sb.append("FAILED");
        } else {
            for (ResultHandler.ComparableDefinition def : cd) {
                sb.append(def.toString());
            }
        }
        return sb.toString();
    }
}

