/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.gcmon;

import java.io.IOException;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.JMX;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.gridkit.jvmtool.gcmon.GarbageCollectionEventConsumer;
import org.gridkit.jvmtool.gcmon.GarbageCollectionSummary;

public class GcEventPoller
implements Runnable {
    private static final ObjectName RUNTIME_MXBEAN = GcEventPoller.mname("java.lang:type=Runtime");
    protected final MBeanServerConnection mserver;
    protected final GarbageCollectionEventConsumer eventSink;
    protected long jvmStartTime;
    protected List<GcTracker> trackers = new ArrayList<GcTracker>();

    private static ObjectName mname(String name) {
        try {
            return new ObjectName(name);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    public GcEventPoller(MBeanServerConnection mserver, GarbageCollectionEventConsumer eventSink) {
        this.mserver = mserver;
        this.eventSink = eventSink;
        RuntimeMXBean runtime = JMX.newMXBeanProxy(mserver, RUNTIME_MXBEAN, RuntimeMXBean.class);
        this.jvmStartTime = runtime.getStartTime();
        this.initTrackers();
    }

    private void initTrackers() {
        try {
            for (ObjectName name : this.mserver.queryNames(null, null)) {
                if (!name.getDomain().equals("java.lang") || !"GarbageCollector".equals(name.getKeyProperty("type"))) continue;
                GcTracker tracker = new GcTracker(name, name.getKeyProperty("name"));
                this.initTracker(tracker);
                this.trackers.add(tracker);
                tracker.capture();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void initTracker(GcTracker tracker) throws InstanceNotFoundException, IOException {
    }

    @Override
    public void run() {
        for (GcTracker tracker : this.trackers) {
            try {
                tracker.capture();
            }
            catch (JMException e) {
            }
            catch (IOException iOException) {}
        }
    }

    public ExecutorService schedule(long period) {
        ScheduledThreadPoolExecutor sp = new ScheduledThreadPoolExecutor(1);
        sp.scheduleAtFixedRate(this, period, period, TimeUnit.MILLISECONDS);
        return sp;
    }

    private static class MemUsage {
        String name;
        long init;
        long used;
        long commited;
        long max;

        public MemUsage(String name, MemoryUsage mu) {
            this(name, mu.getInit(), mu.getUsed(), mu.getCommitted(), mu.getMax());
        }

        public MemUsage(String name, long init, long used, long commited, long max) {
            this.name = name;
            this.init = init;
            this.used = used;
            this.commited = commited;
            this.max = max;
        }
    }

    private static class GcSummary
    implements GarbageCollectionSummary {
        private String name;
        private long timestamp;
        private long durationMs;
        private long collectionCount;
        private long collectionTotalTime;
        private Map<String, MemUsage> before = new HashMap<String, MemUsage>();
        private Map<String, MemUsage> after = new HashMap<String, MemUsage>();

        private GcSummary() {
        }

        @Override
        public long timestamp() {
            return this.timestamp;
        }

        @Override
        public long duration() {
            return TimeUnit.MILLISECONDS.toMicros(this.durationMs);
        }

        @Override
        public String collectorName() {
            return this.name;
        }

        @Override
        public long collectionCount() {
            return this.collectionCount;
        }

        @Override
        public long collectionTotalTime() {
            return this.collectionTotalTime;
        }

        @Override
        public Iterable<String> memorySpaces() {
            return this.before.keySet();
        }

        @Override
        public long memoryBefore(String spaceId) {
            MemUsage mu = this.before.get(spaceId);
            if (mu == null) {
                return Long.MIN_VALUE;
            }
            return mu.used;
        }

        @Override
        public long memoryAfter(String spaceId) {
            MemUsage mu = this.after.get(spaceId);
            if (mu == null) {
                return Long.MIN_VALUE;
            }
            return mu.used;
        }

        @Override
        public long memoryMax(String spaceId) {
            MemUsage mu = this.after.get(spaceId);
            if (mu == null) {
                return Long.MIN_VALUE;
            }
            return mu.max;
        }

        @Override
        public String memorySpaceName(String spaceId) {
            MemUsage mu = this.after.get(spaceId);
            if (mu == null) {
                return null;
            }
            return mu.name;
        }
    }

    class GcTracker {
        ObjectName name;
        String collectorName;
        long lastReportedEvent = -1L;

        public GcTracker(ObjectName name, String collectorName) {
            this.name = name;
            this.collectorName = collectorName;
        }

        public synchronized void capture() throws JMException, IOException {
            CompositeData lastGc = this.getLastGcInfo();
            if (lastGc != null) {
                long id = this.along(lastGc.get("id"));
                long ts = this.along(lastGc.get("startTime"));
                if (ts > 0L && id != this.lastReportedEvent) {
                    this.processGcEvent(lastGc);
                }
            }
        }

        protected synchronized void processGcEvent(CompositeData lastGc) throws JMException, IOException {
            MemUsage mu;
            String spaceId;
            String pool;
            long id = this.along(lastGc.get("id"));
            if (this.lastReportedEvent == id) {
                return;
            }
            this.lastReportedEvent = id;
            long dur = this.along(lastGc.get("duration"));
            long startTs = this.along(lastGc.get("startTime")) + GcEventPoller.this.jvmStartTime;
            Map beforeGC = (Map)lastGc.get("memoryUsageBeforeGc");
            Map afterGC = (Map)lastGc.get("memoryUsageAfterGc");
            GcSummary summary = new GcSummary();
            summary.name = this.collectorName;
            summary.timestamp = startTs;
            summary.durationMs = dur;
            summary.collectionCount = id;
            summary.collectionTotalTime = this.totalTime(id);
            for (Map.Entry e : beforeGC.entrySet()) {
                pool = (String)((List)e.getKey()).get(0);
                spaceId = this.toSpaceId(pool);
                MemoryUsage membefore = MemoryUsage.from((CompositeData)((CompositeData)e.getValue()).get("value"));
                mu = new MemUsage(pool, membefore);
                summary.before.put(spaceId, mu);
            }
            for (Map.Entry e : afterGC.entrySet()) {
                MemUsage memafter;
                pool = (String)((List)e.getKey()).get(0);
                spaceId = this.toSpaceId(pool);
                mu = memafter = new MemUsage(pool, MemoryUsage.from((CompositeData)((CompositeData)e.getValue()).get("value")));
                summary.after.put(spaceId, mu);
            }
            GcEventPoller.this.eventSink.consume(summary);
        }

        private String toSpaceId(String key) {
            return key.toLowerCase().replace(' ', '-');
        }

        private long along(Object v) {
            return ((Number)v).longValue();
        }

        private long totalTime(long id) throws JMException, IOException {
            AttributeList list = GcEventPoller.this.mserver.getAttributes(this.name, new String[]{"CollectionCount", "CollectionTime"});
            long rid = ((Number)((Attribute)list.get(0)).getValue()).longValue();
            if (id == rid) {
                return ((Number)((Attribute)list.get(1)).getValue()).longValue();
            }
            return -1L;
        }

        private CompositeData getLastGcInfo() throws JMException, IOException {
            return (CompositeData)GcEventPoller.this.mserver.getAttribute(this.name, "LastGcInfo");
        }
    }
}

