/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.cmd;

import org.hyperic.sigar.ProcMem;
import org.hyperic.sigar.Sigar;

public class MemWatch {
    static final int SLEEP_TIME = 10000;

    public static void main(String[] args) throws Exception {
        Sigar sigar = new Sigar();
        if (args.length != 1) {
            throw new Exception("Usage: MemWatch pid");
        }
        long pid = Long.parseLong(args[0]);
        long lastTime = System.currentTimeMillis();
        ProcMem last = sigar.getProcMem(pid);
        while (true) {
            ProcMem cur;
            StringBuffer diff;
            if ((diff = MemWatch.diff(last, cur = sigar.getProcMem(pid))).length() == 0) {
                System.out.println("no change (size=" + Sigar.formatSize(cur.getSize()) + ")");
            } else {
                long curTime = System.currentTimeMillis();
                long timeDiff = curTime - lastTime;
                lastTime = curTime;
                diff.append(" after " + timeDiff + "ms");
                System.out.println(diff);
            }
            last = cur;
            Thread.sleep(10000L);
        }
    }

    private static StringBuffer diff(ProcMem last, ProcMem cur) {
        StringBuffer buf = new StringBuffer();
        long diff = cur.getSize() - last.getSize();
        if (diff != 0L) {
            buf.append("size=" + diff);
        }
        if ((diff = cur.getResident() - last.getResident()) != 0L) {
            buf.append(", resident=" + diff);
        }
        if ((diff = cur.getShare() - last.getShare()) != 0L) {
            buf.append(", share=" + diff);
        }
        return buf;
    }
}

