/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1.postings;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.IOException;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.cassandra.index.sai.disk.io.SeekingRandomAccessInput;
import org.apache.cassandra.index.sai.disk.v1.DirectReaders;
import org.apache.cassandra.index.sai.disk.v1.LongArray;
import org.apache.cassandra.index.sai.metrics.QueryEventListener;
import org.apache.cassandra.index.sai.postings.OrdinalPostingList;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.RandomAccessInput;
import org.apache.lucene.util.LongValues;
import org.apache.lucene.util.packed.DirectReader;

@NotThreadSafe
public class PostingsReader
implements OrdinalPostingList {
    private final IndexInput input;
    private final SeekingRandomAccessInput seekingInput;
    private final QueryEventListener.PostingListEventListener listener;
    private final BlocksSummary summary;
    private int blockIndex;
    private int postingIndex;
    private long totalPostingsRead;
    private long actualPosting;
    private LongValues currentFoRValues;
    private long postingsDecoded = 0L;

    @VisibleForTesting
    public PostingsReader(IndexInput input, long summaryOffset, QueryEventListener.PostingListEventListener listener) throws IOException {
        this(input, new BlocksSummary(input, summaryOffset), listener);
    }

    public PostingsReader(IndexInput input, BlocksSummary summary, QueryEventListener.PostingListEventListener listener) throws IOException {
        this.input = input;
        this.seekingInput = new SeekingRandomAccessInput(input);
        this.listener = listener;
        this.summary = summary;
        this.reBuffer();
    }

    @Override
    public long getOrdinal() {
        return this.totalPostingsRead;
    }

    @Override
    public void close() {
        this.listener.postingDecoded(this.postingsDecoded);
        FileUtils.closeQuietly((Closeable)this.input);
        this.summary.close();
    }

    @Override
    public long size() {
        return this.summary.numPostings;
    }

    @Override
    public long advance(long targetRowID) throws IOException {
        this.listener.onAdvance();
        int block = this.binarySearchBlocks(targetRowID);
        if (block < 0) {
            block = -block - 1;
        }
        if (this.blockIndex == block + 1) {
            return this.slowAdvance(targetRowID);
        }
        assert (block > 0);
        this.lastPosInBlock(block - 1);
        return this.slowAdvance(targetRowID);
    }

    private long slowAdvance(long targetRowID) throws IOException {
        while (this.totalPostingsRead < (long)this.summary.numPostings) {
            long segmentRowId = this.peekNext();
            this.advanceOnePosition(segmentRowId);
            if (segmentRowId < targetRowID) continue;
            return segmentRowId;
        }
        return Long.MAX_VALUE;
    }

    private int binarySearchBlocks(long targetRowID) {
        int lowBlockIndex = this.blockIndex - 1;
        int highBlockIndex = Math.toIntExact(this.summary.maxValues.length()) - 1;
        if (lowBlockIndex <= highBlockIndex && targetRowID <= this.summary.maxValues.get(lowBlockIndex)) {
            return lowBlockIndex;
        }
        while (lowBlockIndex <= highBlockIndex) {
            int midBlockIndex = lowBlockIndex + (highBlockIndex - lowBlockIndex >> 1);
            long maxValueOfMidBlock = this.summary.maxValues.get(midBlockIndex);
            if (maxValueOfMidBlock < targetRowID) {
                lowBlockIndex = midBlockIndex + 1;
                continue;
            }
            if (maxValueOfMidBlock > targetRowID) {
                highBlockIndex = midBlockIndex - 1;
                continue;
            }
            if (midBlockIndex > 0 && this.summary.maxValues.get(midBlockIndex - 1) == targetRowID) {
                highBlockIndex = midBlockIndex - 1;
                continue;
            }
            return midBlockIndex;
        }
        return -(lowBlockIndex + 1);
    }

    private void lastPosInBlock(int block) {
        this.actualPosting = this.summary.maxValues.get(block);
        this.totalPostingsRead += (long)(this.summary.blockSize - this.postingIndex) + (long)(block - this.blockIndex + 1) * (long)this.summary.blockSize;
        this.blockIndex = block + 1;
        this.postingIndex = this.summary.blockSize;
    }

    @Override
    public long nextPosting() throws IOException {
        long next = this.peekNext();
        if (next != Long.MAX_VALUE) {
            this.advanceOnePosition(next);
        }
        return next;
    }

    private long peekNext() throws IOException {
        if (this.totalPostingsRead >= (long)this.summary.numPostings) {
            return Long.MAX_VALUE;
        }
        if (this.postingIndex == this.summary.blockSize) {
            this.reBuffer();
        }
        return this.actualPosting + (long)this.nextFoRValue();
    }

    private int nextFoRValue() {
        long id = this.currentFoRValues.get((long)this.postingIndex);
        ++this.postingsDecoded;
        return Math.toIntExact(id);
    }

    private void advanceOnePosition(long nextPosting) {
        this.actualPosting = nextPosting;
        ++this.totalPostingsRead;
        ++this.postingIndex;
    }

    private void reBuffer() throws IOException {
        long pointer = this.summary.offsets.get(this.blockIndex);
        if (pointer < 4L) {
            throw new CorruptIndexException(String.format("Invalid block offset %d for postings block idx %d", pointer, this.blockIndex), (DataInput)this.input);
        }
        this.input.seek(pointer);
        long left = (long)this.summary.numPostings - this.totalPostingsRead;
        assert (left > 0L);
        this.readFoRBlock(this.input);
        ++this.blockIndex;
        this.postingIndex = 0;
    }

    private void readFoRBlock(IndexInput in) throws IOException {
        if (this.blockIndex == 0) {
            this.actualPosting = in.readVLong();
        }
        byte bitsPerValue = in.readByte();
        long currentPosition = in.getFilePointer();
        if (bitsPerValue == 0) {
            this.currentFoRValues = LongValues.ZEROES;
            return;
        }
        if (bitsPerValue > 64) {
            throw new CorruptIndexException(String.format("Postings list #%s block is corrupted. Bits per value should be no more than 64 and is %d.", this.blockIndex, bitsPerValue), (DataInput)this.input);
        }
        this.currentFoRValues = DirectReader.getInstance((RandomAccessInput)this.seekingInput, (int)bitsPerValue, (long)currentPosition);
    }

    public static class BlocksSummary {
        private final IndexInput input;
        final int blockSize;
        final int numPostings;
        final LongArray offsets;
        final LongArray maxValues;

        public BlocksSummary(IndexInput input, long offset) throws IOException {
            this.input = input;
            input.seek(offset);
            this.blockSize = input.readVInt();
            this.numPostings = input.readVInt();
            SeekingRandomAccessInput randomAccessInput = new SeekingRandomAccessInput(input);
            int numBlocks = input.readVInt();
            long maxBlockValuesLength = input.readVLong();
            long maxBlockValuesOffset = input.getFilePointer() + maxBlockValuesLength;
            byte offsetBitsPerValue = input.readByte();
            DirectReaders.checkBitsPerValue(offsetBitsPerValue, input, () -> "Postings list header");
            LongValues lvOffsets = offsetBitsPerValue == 0 ? LongValues.ZEROES : DirectReader.getInstance((RandomAccessInput)randomAccessInput, (int)offsetBitsPerValue, (long)input.getFilePointer());
            this.offsets = new LongArrayReader(lvOffsets, numBlocks);
            input.seek(maxBlockValuesOffset);
            byte valuesBitsPerValue = input.readByte();
            DirectReaders.checkBitsPerValue(valuesBitsPerValue, input, () -> "Postings list header");
            LongValues lvValues = valuesBitsPerValue == 0 ? LongValues.ZEROES : DirectReader.getInstance((RandomAccessInput)randomAccessInput, (int)valuesBitsPerValue, (long)input.getFilePointer());
            this.maxValues = new LongArrayReader(lvValues, numBlocks);
        }

        void close() {
            FileUtils.closeQuietly((Closeable)this.input);
        }

        private static class LongArrayReader
        implements LongArray {
            private final LongValues reader;
            private final int length;

            private LongArrayReader(LongValues reader, int length) {
                this.reader = reader;
                this.length = length;
            }

            @Override
            public long get(long idx) {
                return this.reader.get(idx);
            }

            @Override
            public long length() {
                return this.length;
            }

            @Override
            public long indexOf(long value) {
                throw new UnsupportedOperationException();
            }
        }
    }
}

