/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import java.util.Optional;
import org.apache.cassandra.schema.DistributedSchema;
import org.apache.cassandra.schema.Keyspaces;

public interface SchemaTransformation {
    public Keyspaces apply(Keyspaces var1);

    default public Optional<Long> fixedTimestampMicros() {
        return Optional.empty();
    }

    public static class SchemaTransformationResult {
        public final DistributedSchema before;
        public final DistributedSchema after;
        public final Keyspaces.KeyspacesDiff diff;

        public SchemaTransformationResult(DistributedSchema before, DistributedSchema after, Keyspaces.KeyspacesDiff diff) {
            this.before = before;
            this.after = after;
            this.diff = diff;
        }

        public String toString() {
            return String.format("SchemaTransformationResult{%s --> %s, diff=%s}", this.before.getVersion(), this.after.getVersion(), this.diff);
        }
    }
}

