/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.common.utils;

import java.time.Duration;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.cassandra.sidecar.common.utils.Preconditions;

public final class TimeUtils {
    private TimeUtils() {
        throw new IllegalStateException(this.getClass() + " is a static utility class and shall not be instantiated");
    }

    public static Duration randomDuration(Duration minimum, Duration maximum) {
        Preconditions.checkArgument(minimum.compareTo(maximum) <= 0, "Minimum duration must be less or equal to maximum duration");
        return Duration.ofMillis(ThreadLocalRandom.current().nextLong(minimum.toMillis(), maximum.toMillis() + 1L));
    }
}

