/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.handlers.livemigration;

import com.google.inject.Inject;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.HttpException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.cassandra.sidecar.acl.authorization.BasicPermissions;
import org.apache.cassandra.sidecar.cluster.instance.InstanceMetadata;
import org.apache.cassandra.sidecar.concurrent.ExecutorPools;
import org.apache.cassandra.sidecar.config.LiveMigrationConfiguration;
import org.apache.cassandra.sidecar.config.SidecarConfiguration;
import org.apache.cassandra.sidecar.handlers.AbstractHandler;
import org.apache.cassandra.sidecar.handlers.AccessProtected;
import org.apache.cassandra.sidecar.handlers.livemigration.LiveMigrationDirType;
import org.apache.cassandra.sidecar.livemigration.LiveMigrationInstanceMetadataUtil;
import org.apache.cassandra.sidecar.livemigration.LiveMigrationPlaceholderUtil;
import org.apache.cassandra.sidecar.utils.CassandraInputValidator;
import org.apache.cassandra.sidecar.utils.InstanceMetadataFetcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiveMigrationFileStreamHandler
extends AbstractHandler<Void>
implements AccessProtected {
    private static final Logger LOGGER = LoggerFactory.getLogger(LiveMigrationFileStreamHandler.class);
    private final Map<Integer, List<PathMatcher>> fileExclusionsByInstanceId = new ConcurrentHashMap<Integer, List<PathMatcher>>();
    private final Map<Integer, List<PathMatcher>> dirExclusionsByInstanceId = new ConcurrentHashMap<Integer, List<PathMatcher>>();
    private final LiveMigrationConfiguration liveMigrationConfiguration;

    @Inject
    public LiveMigrationFileStreamHandler(InstanceMetadataFetcher metadataFetcher, ExecutorPools executorPools, CassandraInputValidator validator, SidecarConfiguration sidecarConfiguration) {
        super(metadataFetcher, executorPools, validator);
        this.liveMigrationConfiguration = sidecarConfiguration.liveMigrationConfiguration();
    }

    @Override
    protected Void extractParamsOrThrow(RoutingContext context) {
        int index;
        String dirType = context.pathParam("dirType");
        if (null == dirType || dirType.isEmpty() || null == LiveMigrationDirType.find(dirType)) {
            throw new HttpException(HttpResponseStatus.BAD_REQUEST.code(), "Invalid directory type: " + dirType);
        }
        String dirIndex = context.pathParam("dirIndex");
        try {
            index = Integer.parseInt(dirIndex);
        }
        catch (NumberFormatException formatException) {
            throw new HttpException(HttpResponseStatus.BAD_REQUEST.code(), "Invalid directoryIndex: " + dirIndex);
        }
        if (index < 0) {
            throw new HttpException(HttpResponseStatus.BAD_REQUEST.code(), "Invalid directoryIndex: " + dirIndex);
        }
        return null;
    }

    @Override
    protected void handleInternal(RoutingContext rc, HttpServerRequest httpRequest, @NotNull String host, SocketAddress remoteAddress, @Nullable Void request) {
        String localFile;
        String reqPath = URLDecoder.decode(rc.request().path(), StandardCharsets.UTF_8);
        if (reqPath.contains("/../") || reqPath.endsWith("/..")) {
            LOGGER.warn("Tried to access file using relative path({}). Rejecting the request.", (Object)reqPath);
            rc.response().setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).end();
            return;
        }
        InstanceMetadata instanceMeta = this.metadataFetcher.instance(host);
        String normalizedPath = rc.normalizedPath();
        try {
            localFile = LiveMigrationInstanceMetadataUtil.localPath(normalizedPath, instanceMeta);
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("Invalid path", (Throwable)e);
            rc.response().setStatusCode(HttpResponseStatus.NOT_FOUND.code()).end();
            return;
        }
        Path path = Paths.get(localFile, new String[0]);
        this.executorPools.service().executeBlocking(() -> this.isInvalidPath(rc, path, reqPath, instanceMeta)).onSuccess(invalid -> {
            if (!invalid.booleanValue()) {
                rc.put("fileToTransfer", (Object)localFile);
                rc.next();
            }
        });
    }

    private boolean isInvalidPath(RoutingContext rc, Path path, String reqPath, InstanceMetadata instanceMeta) {
        if (!Files.exists(path, new LinkOption[0])) {
            LOGGER.info("Requested file is not found. file={}", (Object)path);
            rc.response().setStatusCode(HttpResponseStatus.NOT_FOUND.code()).end();
            return true;
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            LOGGER.info("Cannot transfer directory. path={}.", (Object)reqPath);
            rc.response().setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).end();
            return true;
        }
        if (this.isExcluded(path, instanceMeta)) {
            LOGGER.debug("Requested path or one of its parent directories is excluded from Live Migration. path={}", (Object)reqPath);
            rc.response().setStatusCode(HttpResponseStatus.NOT_FOUND.code()).end();
            return true;
        }
        return false;
    }

    private boolean isExcluded(Path localFile, InstanceMetadata instanceMetadata) {
        return this.isFileExcluded(localFile, instanceMetadata) || this.isDirExcluded(localFile.getParent(), instanceMetadata);
    }

    private boolean isFileExcluded(Path localFile, InstanceMetadata instanceMetadata) {
        List<PathMatcher> fileExclusionMatchers = this.getPathMatchers(this.fileExclusionsByInstanceId, instanceMetadata, LiveMigrationConfiguration::filesToExclude);
        return this.isMatch(localFile, fileExclusionMatchers);
    }

    private boolean isDirExcluded(Path dir, InstanceMetadata instanceMetadata) {
        List<PathMatcher> dirExclusionMatchers = this.getPathMatchers(this.dirExclusionsByInstanceId, instanceMetadata, LiveMigrationConfiguration::directoriesToExclude);
        while (dir != null) {
            if (this.isMatch(dir, dirExclusionMatchers)) {
                return true;
            }
            dir = dir.getParent();
        }
        return false;
    }

    private List<PathMatcher> getPathMatchers(Map<Integer, List<PathMatcher>> map, InstanceMetadata instanceMetadata, Function<LiveMigrationConfiguration, Set<String>> exclusionProvider) {
        return map.computeIfAbsent(instanceMetadata.id(), id -> {
            Set exclusions = (Set)exclusionProvider.apply(this.liveMigrationConfiguration);
            ArrayList matchers = new ArrayList(exclusions.size());
            for (String placeholderPattern : exclusions) {
                Set<String> filePatterns = LiveMigrationPlaceholderUtil.replacePlaceholder(placeholderPattern, instanceMetadata);
                filePatterns.forEach(filePattern -> matchers.add(FileSystems.getDefault().getPathMatcher((String)filePattern)));
            }
            return matchers;
        });
    }

    private boolean isMatch(Path localFile, List<PathMatcher> pathMatchers) {
        if (null == pathMatchers || pathMatchers.isEmpty()) {
            return false;
        }
        for (PathMatcher pathMatcher : pathMatchers) {
            if (!pathMatcher.matches(localFile)) continue;
            LOGGER.debug("Requested file is excluded from Live Migration. file={}", (Object)localFile);
            return true;
        }
        return false;
    }

    @Override
    public Set<Authorization> requiredAuthorizations() {
        return Set.of(BasicPermissions.STREAM_FILES.toAuthorization());
    }
}

