/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.metrics.server;

import com.codahale.metrics.DefaultSettableGauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.util.Objects;
import java.util.function.Function;
import org.apache.cassandra.sidecar.metrics.DeltaGauge;
import org.apache.cassandra.sidecar.metrics.NamedMetric;

public class CdcMetrics {
    public static final String DOMAIN = "Sidecar.Server.Cdc";
    protected final MetricRegistry metricRegistry;
    public final NamedMetric<DeltaGauge> cdcRawCleanerFailed;
    public final NamedMetric<DeltaGauge> orphanedIdx;
    public final NamedMetric<DefaultSettableGauge<Integer>> oldestSegmentAge;
    public final NamedMetric<DeltaGauge> totalConsumedCdcBytes;
    public final NamedMetric<DefaultSettableGauge<Long>> totalCdcSpaceUsed;
    public final NamedMetric<DeltaGauge> deletedSegment;
    public final NamedMetric<DeltaGauge> lowCdcRawSpace;
    public final NamedMetric<DeltaGauge> criticalCdcRawSpace;

    public CdcMetrics(MetricRegistry metricRegistry) {
        this.metricRegistry = Objects.requireNonNull(metricRegistry, "Metric registry can not be null");
        this.cdcRawCleanerFailed = this.createMetric("CleanerFailed", name -> (DeltaGauge)metricRegistry.gauge(name, DeltaGauge::new));
        this.totalConsumedCdcBytes = this.createMetric("TotalConsumedBytes", name -> (DeltaGauge)metricRegistry.gauge(name, DeltaGauge::new));
        this.totalCdcSpaceUsed = this.createMetric("TotalSpaceUsed", name -> (DefaultSettableGauge)metricRegistry.gauge(name, () -> new DefaultSettableGauge((Object)0L)));
        this.orphanedIdx = this.createMetric("OrphanedIdxFile", name -> (DeltaGauge)metricRegistry.gauge(name, DeltaGauge::new));
        this.deletedSegment = this.createMetric("DeletedSegment", name -> (DeltaGauge)metricRegistry.gauge(name, DeltaGauge::new));
        this.oldestSegmentAge = this.createMetric("OldestSegmentAgeSeconds", name -> (DefaultSettableGauge)metricRegistry.gauge(name, () -> new DefaultSettableGauge((Object)0)));
        this.lowCdcRawSpace = this.createMetric("LowSpace", name -> (DeltaGauge)metricRegistry.gauge(name, DeltaGauge::new));
        this.criticalCdcRawSpace = this.createMetric("CriticalSpace", name -> (DeltaGauge)metricRegistry.gauge(name, DeltaGauge::new));
    }

    private <T extends Metric> NamedMetric<T> createMetric(String simpleName, Function<String, T> metricCreator) {
        return NamedMetric.builder(metricCreator).withDomain(DOMAIN).withName(simpleName).build();
    }
}

