/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.modules;

import com.google.inject.AbstractModule;
import com.google.inject.multibindings.ProvidesIntoMap;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import org.apache.cassandra.sidecar.common.response.InstanceFilesListResponse;
import org.apache.cassandra.sidecar.handlers.FileStreamHandler;
import org.apache.cassandra.sidecar.handlers.livemigration.LiveMigrationApiEnableDisableHandler;
import org.apache.cassandra.sidecar.handlers.livemigration.LiveMigrationFileStreamHandler;
import org.apache.cassandra.sidecar.handlers.livemigration.LiveMigrationListInstanceFilesHandler;
import org.apache.cassandra.sidecar.handlers.livemigration.LiveMigrationMap;
import org.apache.cassandra.sidecar.handlers.livemigration.LiveMigrationMapSidecarConfigImpl;
import org.apache.cassandra.sidecar.modules.multibindings.KeyClassMapKey;
import org.apache.cassandra.sidecar.modules.multibindings.VertxRouteMapKeys;
import org.apache.cassandra.sidecar.routes.RouteBuilder;
import org.apache.cassandra.sidecar.routes.VertxRoute;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;

@Path(value="/")
public class LiveMigrationModule
extends AbstractModule {
    protected void configure() {
        this.bind(LiveMigrationMap.class).to(LiveMigrationMapSidecarConfigImpl.class);
    }

    @GET
    @Path(value="/api/v1/live-migration/files/:dirType/:dirIndex/*")
    @Operation(summary="Stream file for live migration", description="Streams a file for live migration data transfer")
    @APIResponses(value={@APIResponse(description="File stream for live migration initiated successfully", responseCode="200", content={@Content(mediaType="application/octet-stream", schema=@Schema(type=SchemaType.STRING))}), @APIResponse(responseCode="403", description="Live migration not enabled or file access denied", content={@Content(mediaType="application/json", schema=@Schema(type=SchemaType.OBJECT))})})
    @ProvidesIntoMap
    @KeyClassMapKey(value=VertxRouteMapKeys.LiveMigrationFileStreamHandlerRouteKey.class)
    VertxRoute downloadFileRoute(RouteBuilder.Factory factory, LiveMigrationApiEnableDisableHandler liveMigrationApiEnableDisableHandler, LiveMigrationFileStreamHandler liveMigrationFileStreamHandler, FileStreamHandler fileStreamHandler) {
        return factory.builderForRoute().handler((Handler<RoutingContext>)((Handler)liveMigrationApiEnableDisableHandler::isSource)).handler(liveMigrationFileStreamHandler).handler(fileStreamHandler).build();
    }

    @GET
    @Path(value="/api/v1/live-migration/files")
    @Operation(summary="List instance files", description="Lists files available on an instance for live migration purposes")
    @APIResponses(value={@APIResponse(description="Instance files listed successfully", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=InstanceFilesListResponse.class))}), @APIResponse(responseCode="403", description="Live migration not enabled or node not configured for migration", content={@Content(mediaType="application/json", schema=@Schema(type=SchemaType.OBJECT))})})
    @ProvidesIntoMap
    @KeyClassMapKey(value=VertxRouteMapKeys.LiveMigrationListInstanceFilesRouteKey.class)
    VertxRoute listInstanceFiles(RouteBuilder.Factory factory, LiveMigrationApiEnableDisableHandler liveMigrationApiEnableDisableHandler, LiveMigrationListInstanceFilesHandler liveMigrationListInstanceFilesHandler) {
        return factory.builderForRoute().handler((Handler<RoutingContext>)((Handler)liveMigrationApiEnableDisableHandler::isSourceOrDestination)).handler(liveMigrationListInstanceFilesHandler).build();
    }
}

