/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oidc.idp;

import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.rs.security.jose.jwa.SignatureAlgorithm;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;
import org.apache.cxf.rs.security.jose.jwt.JwtClaims;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.ClientAccessToken;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.provider.AccessTokenResponseFilter;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServerJoseJwtProducer;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;
import org.apache.cxf.rs.security.oidc.common.IdToken;
import org.apache.cxf.rs.security.oidc.idp.IdTokenProvider;
import org.apache.cxf.rs.security.oidc.idp.OidcUserSubject;
import org.apache.cxf.rs.security.oidc.utils.OidcUtils;

public class IdTokenResponseFilter
extends OAuthServerJoseJwtProducer
implements AccessTokenResponseFilter {
    private IdTokenProvider idTokenProvider;
    private WebClient keyServiceClient;

    public void process(ClientAccessToken ct, ServerAccessToken st) {
        if (st.getResponseType() != null && "code token".equals(st.getResponseType()) && "implicit".equals(st.getGrantType())) {
            return;
        }
        if (ct.getApprovedScope() == null || !ct.getApprovedScope().contains("openid")) {
            return;
        }
        String idToken = this.getProcessedIdToken(st);
        if (idToken != null) {
            ct.getParameters().put("id_token", idToken);
        }
    }

    private String getProcessedIdToken(ServerAccessToken st) {
        OidcUserSubject sub;
        if (this.idTokenProvider != null) {
            IdToken idToken = this.idTokenProvider.getIdToken(st.getClient().getClientId(), st.getSubject(), OAuthUtils.convertPermissionsToScopeList((List)st.getScopes()));
            this.setAtHashAndNonce(idToken, st);
            return this.processJwt(new JwtToken((JwtClaims)idToken), st.getClient());
        }
        if (st.getSubject().getProperties().containsKey("id_token")) {
            return (String)st.getSubject().getProperties().get("id_token");
        }
        if (st.getSubject() instanceof OidcUserSubject && (sub = (OidcUserSubject)st.getSubject()).getIdToken() != null) {
            IdToken idToken = new IdToken(sub.getIdToken());
            idToken.setAudience(st.getClient().getClientId());
            idToken.setAuthorizedParty(st.getClient().getClientId());
            if ("refresh_token".equals(st.getGrantType())) {
                long iat = st.getIssuedAt();
                idToken.setExpiryTime(iat + (idToken.getExpiryTime() - idToken.getIssuedAt()));
                idToken.setIssuedAt(iat);
            }
            this.setAtHashAndNonce(idToken, st);
            return this.processJwt(new JwtToken((JwtClaims)idToken), st.getClient());
        }
        return null;
    }

    private void setAtHashAndNonce(IdToken idToken, ServerAccessToken st) {
        String rType = st.getResponseType();
        boolean atHashRequired = idToken.getAccessTokenHash() == null && (rType == null || !rType.equals("id_token"));
        boolean cHashRequired = idToken.getAuthorizationCodeHash() == null && rType != null && (rType.equals("code id_token token") || rType.equals("code id_token"));
        Message m = JAXRSUtils.getCurrentMessage();
        if (atHashRequired || cHashRequired) {
            Properties props = JwsUtils.loadSignatureOutProperties((boolean)false);
            SignatureAlgorithm sigAlgo = super.isSignWithClientSecret() ? OAuthUtils.getClientSecretSignatureAlgorithm((Properties)props) : JwsUtils.getSignatureAlgorithm((Properties)props, (SignatureAlgorithm)SignatureAlgorithm.RS256);
            if (sigAlgo != SignatureAlgorithm.NONE) {
                String code;
                if (atHashRequired) {
                    String tokenKey = st.getEncodedToken() != null ? st.getEncodedToken() : st.getTokenKey();
                    String atHash = OidcUtils.calculateAccessTokenHash(tokenKey, sigAlgo);
                    idToken.setAccessTokenHash(atHash);
                }
                if (cHashRequired && (code = st.getGrantCode() != null ? st.getGrantCode() : (String)m.getExchange().get((Object)"code")) != null) {
                    idToken.setAuthorizationCodeHash(OidcUtils.calculateAuthorizationCodeHash(code, sigAlgo));
                }
            }
        }
        if (m != null && m.getExchange().containsKey((Object)"nonce")) {
            idToken.setNonce((String)m.getExchange().get((Object)"nonce"));
        } else if (st.getNonce() != null) {
            idToken.setNonce(st.getNonce());
        }
    }

    public void setIdTokenProvider(IdTokenProvider idTokenProvider) {
        this.idTokenProvider = idTokenProvider;
    }

    public String processJwt(JwtToken jwt, Client client) {
        if (this.keyServiceClient != null) {
            LinkedList<String> opers = new LinkedList<String>();
            if (super.isJwsRequired()) {
                opers.add("sign");
            }
            if (super.isJweRequired()) {
                opers.add("encrypt");
            }
            this.keyServiceClient.resetQuery();
            this.keyServiceClient.query("key_ops", new Object[]{opers});
            return (String)this.keyServiceClient.post((Object)jwt, String.class);
        }
        return super.processJwt(jwt, client);
    }

    public void setKeyServiceClient(WebClient keyServiceClient) {
        this.keyServiceClient = keyServiceClient;
    }
}

