/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http_undertow;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.HttpContinueReadHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.core.ServletContainerImpl;
import io.undertow.util.CopyOnWriteMap;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509KeyManager;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.cxf.Bus;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.common.util.SystemPropertyAction;
import org.apache.cxf.configuration.jsse.SSLUtils;
import org.apache.cxf.configuration.jsse.TLSServerParameters;
import org.apache.cxf.configuration.security.FiltersType;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.transport.HttpUriMapper;
import org.apache.cxf.transport.http.HttpServerEngineSupport;
import org.apache.cxf.transport.http_undertow.CXFUndertowHttpHandler;
import org.apache.cxf.transport.http_undertow.CxfUndertowServlet;
import org.apache.cxf.transport.http_undertow.NotFoundHandler;
import org.apache.cxf.transport.http_undertow.ServerEngine;
import org.apache.cxf.transport.http_undertow.ThreadingParameters;
import org.apache.cxf.transport.http_undertow.UndertowHTTPHandler;
import org.apache.cxf.transport.http_undertow.UndertowHTTPServerEngineFactory;
import org.apache.cxf.transport.https.AliasedX509ExtendedKeyManager;
import org.xnio.Options;
import org.xnio.Sequence;
import org.xnio.SslClientAuthMode;

public class UndertowHTTPServerEngine
implements ServerEngine,
HttpServerEngineSupport {
    public static final String DO_NOT_CHECK_URL_PROP = "org.apache.cxf.transports.http_undertow.DontCheckUrl";
    @Deprecated
    public static final String ENABLE_HTTP2_PROP = "org.apache.cxf.transports.http_undertow.EnableHttp2";
    public static final String ENABLE_RECORD_REQUEST_START_TIME_PROP = "org.apache.cxf.transports.http_undertow.EnableRecordRequestStartTime";
    private static final Logger LOG = LogUtils.getL7dLogger(UndertowHTTPServerEngine.class);
    private int port;
    private String host;
    private String protocol = "http";
    private int servantCount;
    private Undertow server;
    private TLSServerParameters tlsServerParameters;
    private SSLContext sslContext;
    private boolean configFinalized;
    private ConcurrentMap<String, UndertowHTTPHandler> registedPaths = new CopyOnWriteMap();
    private boolean continuationsEnabled = true;
    private ServletContext servletContext;
    private PathHandler path;
    private int maxIdleTime = 200000;
    private ThreadingParameters threadingParameters;
    private List<CXFUndertowHttpHandler> handlers;
    private String[] includedCipherSuites;

    public UndertowHTTPServerEngine(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public UndertowHTTPServerEngine() {
    }

    @Override
    public void addServant(URL url, UndertowHTTPHandler handler) {
        String contextName;
        if (this.shouldCheckUrl(handler.getBus())) {
            this.checkRegistedContext(url);
        }
        if (this.server == null) {
            try {
                contextName = HttpUriMapper.getContextName((String)url.getPath());
                this.servletContext = this.buildServletContext(contextName);
                handler.setServletContext(this.servletContext);
                this.server = this.createServer(url, handler);
                this.server.start();
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "START_UP_SERVER_FAILED_MSG", new Object[]{e.getMessage(), this.port});
                try {
                    this.server.stop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.server = null;
                throw new Fault(new Message("START_UP_SERVER_FAILED_MSG", LOG, new Object[]{e.getMessage(), this.port}), (Throwable)e);
            }
        }
        contextName = HttpUriMapper.getContextName((String)url.getPath());
        try {
            this.servletContext = this.buildServletContext(contextName);
        }
        catch (ServletException e) {
            throw new Fault(new Message("START_UP_SERVER_FAILED_MSG", LOG, new Object[]{e.getMessage(), this.port}), (Throwable)e);
        }
        handler.setServletContext(this.servletContext);
        if (handler.isContextMatchExact()) {
            this.path.addExactPath(url.getPath(), (HttpHandler)handler);
        } else {
            String urlPath = url.getPath();
            if (urlPath.isEmpty()) {
                urlPath = "/";
            }
            this.path.addPrefixPath(urlPath, (HttpHandler)handler);
        }
        String smap = HttpUriMapper.getResourceBase((String)url.getPath());
        handler.setName(smap);
        this.registedPaths.put(url.getPath(), handler);
        ++this.servantCount;
    }

    public boolean isHttp2Enabled(Bus bus) {
        Object prop = null;
        if (bus != null) {
            prop = bus.getProperty(ENABLE_HTTP2_PROP);
        }
        if (prop == null) {
            prop = SystemPropertyAction.getPropertyOrNull((String)ENABLE_HTTP2_PROP);
        }
        return PropertyUtils.isTrue((Object)prop) || super.isHttp2Enabled(bus);
    }

    private ServletContext buildServletContext(String contextName) throws ServletException {
        ServletContainerImpl servletContainer = new ServletContainerImpl();
        DeploymentInfo deploymentInfo = new DeploymentInfo();
        deploymentInfo.setClassLoader(Thread.currentThread().getContextClassLoader());
        deploymentInfo.setDeploymentName("cxf-undertow");
        deploymentInfo.setContextPath(contextName);
        ServletInfo asyncServlet = new ServletInfo("default", CxfUndertowServlet.class);
        deploymentInfo.addServlet(asyncServlet);
        servletContainer.addDeployment(deploymentInfo);
        DeploymentManager deploymentManager = servletContainer.getDeployment(deploymentInfo.getDeploymentName());
        deploymentManager.deploy();
        deploymentManager.start();
        return deploymentManager.getDeployment().getServletContext();
    }

    private Undertow createServer(URL url, UndertowHTTPHandler undertowHTTPHandler) throws Exception {
        Undertow.Builder result = Undertow.builder();
        result.setServerOption(UndertowOptions.IDLE_TIMEOUT, (Object)this.getMaxIdleTime());
        if (this.isHttp2Enabled(undertowHTTPHandler.getBus())) {
            result.setServerOption(UndertowOptions.ENABLE_HTTP2, (Object)Boolean.TRUE);
        }
        if (this.shouldEnableRecordRequestStartTime(undertowHTTPHandler.getBus())) {
            result.setServerOption(UndertowOptions.RECORD_REQUEST_START_TIME, (Object)Boolean.TRUE);
        }
        if (this.tlsServerParameters != null) {
            if (this.sslContext == null) {
                this.sslContext = this.createSSLContext();
            }
            result = result.addHttpsListener(this.getPort(), this.getHost(), this.sslContext);
        } else {
            result = result.addHttpListener(this.getPort(), this.getHost());
        }
        this.path = Handlers.path((HttpHandler)new NotFoundHandler());
        if (url.getPath().length() == 0) {
            result = result.setHandler((HttpHandler)Handlers.trace((HttpHandler)undertowHTTPHandler));
        } else {
            if (undertowHTTPHandler.isContextMatchExact()) {
                this.path.addExactPath(url.getPath(), (HttpHandler)undertowHTTPHandler);
            } else {
                this.path.addPrefixPath(url.getPath(), (HttpHandler)undertowHTTPHandler);
            }
            result = result.setHandler(this.wrapHandler((HttpHandler)new HttpContinueReadHandler((HttpHandler)this.path)));
        }
        result = this.decorateUndertowSocketConnection(result);
        result = this.disableSSLv3(result);
        result = this.configureThreads(result);
        return result.build();
    }

    private Undertow.Builder configureThreads(Undertow.Builder builder) {
        if (this.threadingParameters != null) {
            if (this.threadingParameters.isWorkerIOThreadsSet()) {
                builder = builder.setWorkerOption(Options.WORKER_IO_THREADS, (Object)this.threadingParameters.getWorkerIOThreads());
            }
            if (this.threadingParameters.isMinThreadsSet()) {
                builder = builder.setWorkerOption(Options.WORKER_TASK_CORE_THREADS, (Object)this.threadingParameters.getMinThreads());
            }
            if (this.threadingParameters.isMaxThreadsSet()) {
                builder = builder.setWorkerOption(Options.WORKER_TASK_MAX_THREADS, (Object)this.threadingParameters.getMaxThreads());
            }
            if (this.threadingParameters.isWorkerIONameSet()) {
                builder = builder.setWorkerOption(Options.WORKER_NAME, (Object)this.threadingParameters.getWorkerIOName());
            }
        }
        return builder;
    }

    private HttpHandler wrapHandler(HttpHandler handler) {
        HttpHandler nextHandler = handler;
        for (CXFUndertowHttpHandler h : this.getHandlers()) {
            h.setNext(nextHandler);
            nextHandler = h;
        }
        return nextHandler;
    }

    private Undertow.Builder disableSSLv3(Undertow.Builder result) {
        List<String> defaultProtocols = Arrays.asList(TLSServerParameters.getPreferredServerProtocols());
        if (this.tlsServerParameters != null && ("SSLv3".equals(this.tlsServerParameters.getSecureSocketProtocol()) || !this.tlsServerParameters.getIncludeProtocols().isEmpty())) {
            LinkedList<String> protocols = new LinkedList<String>(defaultProtocols);
            protocols.add("SSLv3");
            for (String excludedProtocol : this.tlsServerParameters.getExcludeProtocols()) {
                if (!protocols.contains(excludedProtocol)) continue;
                protocols.remove(excludedProtocol);
            }
            Sequence supportProtocols = Sequence.of(protocols);
            return result.setSocketOption(Options.SSL_ENABLED_PROTOCOLS, (Object)supportProtocols);
        }
        Sequence supportProtocols = Sequence.of(defaultProtocols);
        return result.setSocketOption(Options.SSL_ENABLED_PROTOCOLS, (Object)supportProtocols);
    }

    public Undertow.Builder decorateUndertowSocketConnection(Undertow.Builder builder) {
        if (this.tlsServerParameters != null && this.tlsServerParameters.getClientAuthentication() != null && this.tlsServerParameters.getClientAuthentication().isRequired().booleanValue()) {
            builder = builder.setSocketOption(Options.SSL_CLIENT_AUTH_MODE, (Object)SslClientAuthMode.REQUIRED);
        }
        if (this.tlsServerParameters != null && this.tlsServerParameters.getClientAuthentication() != null && this.tlsServerParameters.getClientAuthentication().isSetWant() && this.tlsServerParameters.getClientAuthentication().isWant().booleanValue() && !this.tlsServerParameters.getClientAuthentication().isRequired().booleanValue()) {
            builder = builder.setSocketOption(Options.SSL_CLIENT_AUTH_MODE, (Object)SslClientAuthMode.REQUESTED);
        }
        if (this.includedCipherSuites != null) {
            builder = builder.setSocketOption(Options.SSL_ENABLED_CIPHER_SUITES, (Object)Sequence.of((Object[])this.includedCipherSuites));
        }
        return builder;
    }

    private boolean shouldCheckUrl(Bus bus) {
        Object prop = null;
        if (bus != null) {
            prop = bus.getProperty(DO_NOT_CHECK_URL_PROP);
        }
        if (prop == null) {
            prop = SystemPropertyAction.getPropertyOrNull((String)DO_NOT_CHECK_URL_PROP);
        }
        return !PropertyUtils.isTrue((Object)prop);
    }

    private boolean shouldEnableRecordRequestStartTime(Bus bus) {
        Object prop = null;
        if (bus != null) {
            prop = bus.getProperty(ENABLE_RECORD_REQUEST_START_TIME_PROP);
        }
        if (prop == null) {
            prop = SystemPropertyAction.getPropertyOrNull((String)ENABLE_RECORD_REQUEST_START_TIME_PROP);
        }
        return PropertyUtils.isTrue((Object)prop);
    }

    protected void checkRegistedContext(URL url) {
        String urlPath = url.getPath();
        for (String registedPath : this.registedPaths.keySet()) {
            if (urlPath.equals(registedPath)) {
                throw new Fault(new Message("ADD_HANDLER_CONTEXT_IS_USED_MSG", LOG, new Object[]{url, registedPath}));
            }
            if (urlPath.equals(HttpUriMapper.getContextName((String)registedPath))) {
                throw new Fault(new Message("ADD_HANDLER_CONTEXT_IS_USED_MSG", LOG, new Object[]{url, registedPath}));
            }
            if (!registedPath.equals(HttpUriMapper.getContextName((String)urlPath))) continue;
            throw new Fault(new Message("ADD_HANDLER_CONTEXT_CONFILICT_MSG", LOG, new Object[]{url, registedPath}));
        }
    }

    @Override
    public void removeServant(URL url) {
        UndertowHTTPHandler handler = (UndertowHTTPHandler)this.registedPaths.remove(url.getPath());
        if (handler == null) {
            return;
        }
        --this.servantCount;
        if (url.getPath().isEmpty()) {
            return;
        }
        if (handler.isContextMatchExact()) {
            this.path.removeExactPath(url.getPath());
        } else {
            this.path.removePrefixPath(url.getPath());
        }
    }

    @Override
    public UndertowHTTPHandler getServant(URL url) {
        return (UndertowHTTPHandler)this.registedPaths.get(url.getPath());
    }

    public String getProtocol() {
        return this.protocol;
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public void setPort(int p) {
        this.port = p;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void finalizeConfig() {
        this.retrieveListenerFactory();
        this.configFinalized = true;
    }

    public void setTlsServerParameters(TLSServerParameters params) {
        this.tlsServerParameters = params;
        if (this.configFinalized) {
            this.retrieveListenerFactory();
        }
    }

    private void retrieveListenerFactory() {
        this.protocol = this.tlsServerParameters != null ? "https" : "http";
        LOG.fine("Configured port " + this.port + " for \"" + this.protocol + "\".");
    }

    public TLSServerParameters getTlsServerParameters() {
        return this.tlsServerParameters;
    }

    public void stop() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    public void shutdown() {
        if (this.shouldDestroyPort()) {
            if (this.servantCount == 0) {
                UndertowHTTPServerEngineFactory.destroyForPort(this.port);
                this.registedPaths.clear();
            } else {
                LOG.log(Level.WARNING, "FAILED_TO_SHUTDOWN_ENGINE_MSG", this.port);
            }
        }
    }

    private boolean shouldDestroyPort() {
        String s = SystemPropertyAction.getPropertyOrNull((String)("org.apache.cxf.transports.http_undertow.DontClosePort." + this.port));
        if (s == null) {
            s = SystemPropertyAction.getPropertyOrNull((String)"org.apache.cxf.transports.http_undertow.DontClosePort");
        }
        return Boolean.valueOf(s) == false;
    }

    protected SSLContext createSSLContext() throws Exception {
        String proto = this.tlsServerParameters.getSecureSocketProtocol() == null ? "TLS" : this.tlsServerParameters.getSecureSocketProtocol();
        SSLContext context = this.tlsServerParameters.getJsseProvider() == null ? SSLContext.getInstance(proto) : SSLContext.getInstance(proto, this.tlsServerParameters.getJsseProvider());
        KeyManager[] keyManagers = this.tlsServerParameters.getKeyManagers();
        if (this.tlsServerParameters.getCertAlias() != null) {
            keyManagers = this.getKeyManagersWithCertAlias(keyManagers);
        }
        context.init(keyManagers, this.tlsServerParameters.getTrustManagers(), this.tlsServerParameters.getSecureRandom());
        String[] supportedCipherSuites = SSLUtils.getServerSupportedCipherSuites((SSLContext)context);
        this.includedCipherSuites = SSLUtils.getCiphersuitesToInclude((List)this.tlsServerParameters.getCipherSuites(), (FiltersType)this.tlsServerParameters.getCipherSuitesFilter(), (String[])context.getServerSocketFactory().getDefaultCipherSuites(), (String[])supportedCipherSuites, (Logger)LOG);
        return context;
    }

    protected KeyManager[] getKeyManagersWithCertAlias(KeyManager[] keyManagers) throws Exception {
        if (this.tlsServerParameters.getCertAlias() != null) {
            for (int idx = 0; idx < keyManagers.length; ++idx) {
                if (!(keyManagers[idx] instanceof X509KeyManager)) continue;
                keyManagers[idx] = new AliasedX509ExtendedKeyManager(this.tlsServerParameters.getCertAlias(), (X509KeyManager)keyManagers[idx]);
            }
        }
        return keyManagers;
    }

    public void setThreadingParameters(ThreadingParameters params) {
        this.threadingParameters = params;
    }

    public boolean isSetThreadingParameters() {
        return this.threadingParameters != null;
    }

    public ThreadingParameters getThreadingParameters() {
        return this.threadingParameters;
    }

    public void setContinuationsEnabled(boolean enabled) {
        this.continuationsEnabled = enabled;
    }

    public boolean getContinuationsEnabled() {
        return this.continuationsEnabled;
    }

    public int getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public void setMaxIdleTime(int maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    public void setHandlers(List<CXFUndertowHttpHandler> h) {
        this.handlers = h;
    }

    public List<CXFUndertowHttpHandler> getHandlers() {
        return this.handlers != null ? this.handlers : new ArrayList<CXFUndertowHttpHandler>();
    }
}

