/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.corba;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.binding.corba.CorbaBinding;
import org.apache.cxf.binding.corba.CorbaConduit;
import org.apache.cxf.binding.corba.CorbaDestination;
import org.apache.cxf.binding.corba.interceptors.CorbaStreamFaultInInterceptor;
import org.apache.cxf.binding.corba.interceptors.CorbaStreamFaultOutInterceptor;
import org.apache.cxf.binding.corba.interceptors.CorbaStreamInInterceptor;
import org.apache.cxf.binding.corba.interceptors.CorbaStreamOutInterceptor;
import org.apache.cxf.binding.corba.utils.OrbConfig;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.wsdl.binding.AbstractWSDLBindingFactory;
import org.apache.cxf.wsdl.interceptors.BareInInterceptor;
import org.apache.cxf.wsdl.interceptors.BareOutInterceptor;

public class CorbaBindingFactory
extends AbstractWSDLBindingFactory
implements ConduitInitiator,
DestinationFactory {
    public static final Collection<String> DEFAULT_NAMESPACES = Arrays.asList("http://cxf.apache.org/bindings/corba", "http://schemas.apache.org/yoko/bindings/corba");
    protected List<String> transportIds = new ArrayList<String>(DEFAULT_NAMESPACES);
    protected OrbConfig orbConfig = new OrbConfig();

    public CorbaBindingFactory() {
        super(DEFAULT_NAMESPACES);
    }

    public void setOrbClass(String cls) {
        this.orbConfig.setOrbClass(cls);
    }

    public void setOrbSingletonClass(String cls) {
        this.orbConfig.setOrbSingletonClass(cls);
    }

    public Binding createBinding(BindingInfo bindingInfo) {
        CorbaBinding binding = new CorbaBinding();
        binding.getInFaultInterceptors().add(new CorbaStreamFaultInInterceptor());
        binding.getOutFaultInterceptors().add(new CorbaStreamFaultOutInterceptor());
        binding.getOutInterceptors().add(new BareOutInterceptor());
        binding.getOutInterceptors().add(new CorbaStreamOutInterceptor());
        binding.getInInterceptors().add(new BareInInterceptor());
        binding.getInInterceptors().add(new CorbaStreamInInterceptor());
        binding.setBindingInfo(bindingInfo);
        return binding;
    }

    public Conduit getConduit(EndpointInfo endpointInfo, Bus bus) throws IOException {
        return this.getConduit(endpointInfo, null, bus);
    }

    public Conduit getConduit(EndpointInfo endpointInfo, EndpointReferenceType target, Bus bus) throws IOException {
        return new CorbaConduit(endpointInfo, target, this.orbConfig);
    }

    public Destination getDestination(EndpointInfo endpointInfo, Bus bus) throws IOException {
        return new CorbaDestination(endpointInfo, this.orbConfig);
    }

    public List<String> getTransportIds() {
        return this.transportIds;
    }

    public void setTransportIds(List<String> ids) {
        this.transportIds = ids;
    }

    public void setOrbArgs(List<String> args) {
        this.orbConfig.setOrbArgs(args);
    }

    public Set<String> getUriPrefixes() {
        HashSet<String> uriPrefixes = new HashSet<String>();
        uriPrefixes.add("IOR");
        uriPrefixes.add("ior");
        uriPrefixes.add("file");
        uriPrefixes.add("relfile");
        uriPrefixes.add("corba");
        return uriPrefixes;
    }

    public OrbConfig getOrbConfig() {
        return this.orbConfig;
    }

    public void setOrbConfig(OrbConfig config) {
        this.orbConfig = config;
    }
}

