/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.core.util;

import java.io.InputStream;
import java.nio.ByteBuffer;

public class ByteBufferInputStream
extends InputStream {
    private final ByteBuffer buffer;

    public ByteBufferInputStream(ByteBuffer buffer) {
        this.buffer = buffer.slice();
    }

    @Override
    public int read() {
        if (this.buffer.hasRemaining()) {
            return 0xFF & this.buffer.get();
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        len = Math.min(len, this.buffer.remaining());
        this.buffer.get(b, off, len);
        return len;
    }

    @Override
    public long skip(long n) {
        n = Math.min((long)this.buffer.remaining(), Math.max(n, 0L));
        this.buffer.position((int)((long)this.buffer.position() + n));
        return n;
    }

    @Override
    public synchronized int available() {
        return this.buffer.remaining();
    }
}

