/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.shadow.org.terracotta.offheapstore.paging;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.ehcache.shadow.org.terracotta.offheapstore.buffersource.BufferSource;
import org.ehcache.shadow.org.terracotta.offheapstore.paging.OffHeapStorageArea;
import org.ehcache.shadow.org.terracotta.offheapstore.paging.Page;
import org.ehcache.shadow.org.terracotta.offheapstore.paging.PageSource;
import org.ehcache.shadow.org.terracotta.offheapstore.storage.allocator.PowerOfTwoAllocator;
import org.ehcache.shadow.org.terracotta.offheapstore.util.DebuggingUtils;
import org.ehcache.shadow.org.terracotta.offheapstore.util.MemoryUnit;
import org.ehcache.shadow.org.terracotta.offheapstore.util.PhysicalMemory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpfrontAllocatingPageSource
implements PageSource {
    public static final String ALLOCATION_LOG_LOCATION = UpfrontAllocatingPageSource.class.getName() + ".allocationDump";
    private static final Logger LOGGER = LoggerFactory.getLogger(UpfrontAllocatingPageSource.class);
    private static final double PROGRESS_LOGGING_STEP_SIZE = 0.1;
    private static final long PROGRESS_LOGGING_THRESHOLD = MemoryUnit.GIGABYTES.toBytes(4L);
    private static final Comparator<Page> REGION_COMPARATOR = (a, b) -> {
        if (a.address() == b.address()) {
            return a.size() - b.size();
        }
        return a.address() - b.address();
    };
    private final SortedMap<Long, Runnable> risingThresholds = new TreeMap<Long, Runnable>();
    private final SortedMap<Long, Runnable> fallingThresholds = new TreeMap<Long, Runnable>();
    private final List<PowerOfTwoAllocator> sliceAllocators = new ArrayList<PowerOfTwoAllocator>();
    private final List<PowerOfTwoAllocator> victimAllocators = new ArrayList<PowerOfTwoAllocator>();
    private final List<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
    private final List<NavigableSet<Page>> victims = new ArrayList<NavigableSet<Page>>();
    private volatile int availableSet = -1;

    public UpfrontAllocatingPageSource(BufferSource source, long toAllocate, int chunkSize) {
        this(source, toAllocate, chunkSize, -1, true);
    }

    public UpfrontAllocatingPageSource(BufferSource source, long toAllocate, int maxChunk, int minChunk) {
        this(source, toAllocate, maxChunk, minChunk, false);
    }

    private UpfrontAllocatingPageSource(BufferSource source, long toAllocate, int maxChunk, int minChunk, boolean fixed) {
        Long totalPhysical = PhysicalMemory.totalPhysicalMemory();
        Long freePhysical = PhysicalMemory.freePhysicalMemory();
        if (totalPhysical != null && toAllocate > totalPhysical) {
            throw new IllegalArgumentException("Attempting to allocate " + DebuggingUtils.toBase2SuffixedString(toAllocate) + "B of memory when the host only contains " + DebuggingUtils.toBase2SuffixedString(totalPhysical) + "B of physical memory");
        }
        if (freePhysical != null && toAllocate > freePhysical) {
            LOGGER.warn("Attempting to allocate {}B of offheap when there is only {}B of free physical memory - some paging will therefore occur.", (Object)DebuggingUtils.toBase2SuffixedString(toAllocate), (Object)DebuggingUtils.toBase2SuffixedString(freePhysical));
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Allocating {}B in chunks", (Object)DebuggingUtils.toBase2SuffixedString(toAllocate));
        }
        for (ByteBuffer buffer : UpfrontAllocatingPageSource.allocateBackingBuffers(source, toAllocate, maxChunk, minChunk, fixed)) {
            this.sliceAllocators.add(new PowerOfTwoAllocator(buffer.capacity()));
            this.victimAllocators.add(new PowerOfTwoAllocator(buffer.capacity()));
            this.victims.add(new TreeSet<Page>(REGION_COMPARATOR));
            this.buffers.add(buffer);
        }
    }

    public long getCapacity() {
        long capacity = 0L;
        for (ByteBuffer buffer : this.buffers) {
            capacity += (long)buffer.capacity();
        }
        return capacity;
    }

    @Override
    public Page allocate(int size, boolean thief, boolean victim, OffHeapStorageArea owner) {
        if (thief) {
            return this.allocateAsThief(size, victim, owner);
        }
        return this.allocateFromFree(size, victim, owner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Page allocateAsThief(int size, boolean victim, OffHeapStorageArea owner) {
        Page free = this.allocateFromFree(size, victim, owner);
        if (free != null) {
            return free;
        }
        PowerOfTwoAllocator victimAllocator = null;
        PowerOfTwoAllocator sliceAllocator = null;
        List<Object> targets = Collections.emptyList();
        ArrayList<AllocatedRegion> tempHolds = new ArrayList<AllocatedRegion>();
        IdentityHashMap releases = new IdentityHashMap();
        UpfrontAllocatingPageSource upfrontAllocatingPageSource = this;
        synchronized (upfrontAllocatingPageSource) {
            for (int i = 0; i < this.victimAllocators.size(); ++i) {
                int n = this.victimAllocators.get(i).find(size, victim ? PowerOfTwoAllocator.Packing.CEILING : PowerOfTwoAllocator.Packing.FLOOR);
                if (n < 0) continue;
                victimAllocator = this.victimAllocators.get(i);
                sliceAllocator = this.sliceAllocators.get(i);
                targets = this.findVictimPages(i, n, size);
                int claimAddress = n;
                for (Page page : targets) {
                    victimAllocator.claim(page.address(), page.size());
                    int claimSize = page.address() - claimAddress;
                    if (claimSize > 0) {
                        tempHolds.add(new AllocatedRegion(claimAddress, claimSize));
                        sliceAllocator.claim(claimAddress, claimSize);
                        victimAllocator.claim(claimAddress, claimSize);
                    }
                    claimAddress = page.address() + page.size();
                }
                int n2 = n + size - claimAddress;
                if (n2 <= 0) break;
                tempHolds.add(new AllocatedRegion(claimAddress, n2));
                sliceAllocator.claim(claimAddress, n2);
                victimAllocator.claim(claimAddress, n2);
                break;
            }
            for (Page page : targets) {
                OffHeapStorageArea a = page.binding();
                Collection collection = (Collection)releases.get(a);
                if (collection == null) {
                    LinkedList<Page> linkedList = new LinkedList<Page>();
                    linkedList.add(page);
                    releases.put(a, linkedList);
                    continue;
                }
                collection.add(page);
            }
        }
        LinkedList<Page> results = new LinkedList<Page>();
        for (Map.Entry entry : releases.entrySet()) {
            OffHeapStorageArea a = (OffHeapStorageArea)entry.getKey();
            Collection collection = (Collection)entry.getValue();
            results.addAll(a.release(collection));
        }
        ArrayList<Page> failedReleases = new ArrayList<Page>();
        UpfrontAllocatingPageSource object = this;
        synchronized (object) {
            for (AllocatedRegion allocatedRegion : tempHolds) {
                sliceAllocator.free(allocatedRegion.address, allocatedRegion.size);
                victimAllocator.free(allocatedRegion.address, allocatedRegion.size);
            }
            if (results.size() == targets.size()) {
                for (Page page : targets) {
                    victimAllocator.free(page.address(), page.size());
                    this.free(page);
                }
                return this.allocateFromFree(size, victim, owner);
            }
            for (Page page : targets) {
                if (results.contains(page)) {
                    victimAllocator.free(page.address(), page.size());
                    this.free(page);
                    continue;
                }
                failedReleases.add(page);
            }
        }
        try {
            Page page = this.allocateAsThief(size, victim, owner);
            return page;
        }
        finally {
            UpfrontAllocatingPageSource upfrontAllocatingPageSource2 = this;
            synchronized (upfrontAllocatingPageSource2) {
                for (Page page : failedReleases) {
                    if (this.victims.get(page.index()).floor(page) != page) continue;
                    victimAllocator.free(page.address(), page.size());
                }
            }
        }
    }

    private List<Page> findVictimPages(int chunk, int address, int size) {
        return new ArrayList<Page>(this.victims.get(chunk).subSet(new Page(null, -1, address, null), new Page(null, -1, address + size, null)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Page allocateFromFree(int size, boolean victim, OffHeapStorageArea owner) {
        if (Integer.bitCount(size) != 1) {
            int rounded = Integer.highestOneBit(size) << 1;
            LOGGER.debug("Request to allocate {}B will allocate {}B", (Object)size, (Object)DebuggingUtils.toBase2SuffixedString(rounded));
            size = rounded;
        }
        if (this.isUnavailable(size)) {
            return null;
        }
        UpfrontAllocatingPageSource upfrontAllocatingPageSource = this;
        synchronized (upfrontAllocatingPageSource) {
            for (int i = 0; i < this.sliceAllocators.size(); ++i) {
                int address = this.sliceAllocators.get(i).allocate(size, victim ? PowerOfTwoAllocator.Packing.CEILING : PowerOfTwoAllocator.Packing.FLOOR);
                if (address < 0) continue;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Allocating a {}B buffer from chunk {} &{}", new Object[]{DebuggingUtils.toBase2SuffixedString(size), i, address});
                }
                ByteBuffer b = ((ByteBuffer)this.buffers.get(i).limit(address + size).position(address)).slice();
                Page p = new Page(b, i, address, owner);
                if (victim) {
                    this.victims.get(i).add(p);
                } else {
                    this.victimAllocators.get(i).claim(address, size);
                }
                if (!this.risingThresholds.isEmpty()) {
                    long allocated = this.getAllocatedSize();
                    this.fireThresholds(allocated - (long)size, allocated);
                }
                return p;
            }
            this.markUnavailable(size);
            return null;
        }
    }

    @Override
    public synchronized void free(Page page) {
        if (page.isFreeable()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Freeing a {}B buffer from chunk {} &{}", new Object[]{DebuggingUtils.toBase2SuffixedString(page.size()), page.index(), page.address()});
            }
            this.markAllAvailable();
            this.sliceAllocators.get(page.index()).free(page.address(), page.size());
            this.victims.get(page.index()).remove(page);
            this.victimAllocators.get(page.index()).tryFree(page.address(), page.size());
            if (!this.fallingThresholds.isEmpty()) {
                long allocated = this.getAllocatedSize();
                this.fireThresholds(allocated + (long)page.size(), allocated);
            }
        }
    }

    public synchronized long getAllocatedSize() {
        long sum = 0L;
        for (PowerOfTwoAllocator a : this.sliceAllocators) {
            sum += (long)a.occupied();
        }
        return sum;
    }

    public long getAllocatedSizeUnSync() {
        long sum = 0L;
        for (PowerOfTwoAllocator a : this.sliceAllocators) {
            sum += (long)a.occupied();
        }
        return sum;
    }

    private boolean isUnavailable(int size) {
        return (this.availableSet & size) == 0;
    }

    private synchronized void markAllAvailable() {
        this.availableSet = -1;
    }

    private synchronized void markUnavailable(int size) {
        this.availableSet &= ~size;
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder("UpfrontAllocatingPageSource");
        for (int i = 0; i < this.buffers.size(); ++i) {
            sb.append("\nChunk ").append(i + 1).append('\n');
            sb.append("Size             : ").append(DebuggingUtils.toBase2SuffixedString(this.buffers.get(i).capacity())).append("B\n");
            sb.append("Free Allocator   : ").append(this.sliceAllocators.get(i)).append('\n');
            sb.append("Victim Allocator : ").append(this.victimAllocators.get(i));
        }
        return sb.toString();
    }

    private synchronized void fireThresholds(long incoming, long outgoing) {
        Collection<Object> thresholds = outgoing > incoming ? this.risingThresholds.subMap(incoming, outgoing).values() : (outgoing < incoming ? this.fallingThresholds.subMap(outgoing, incoming).values() : Collections.emptyList());
        for (Runnable r : thresholds) {
            try {
                r.run();
            }
            catch (Throwable t) {
                LOGGER.error("Throwable thrown by threshold action", t);
            }
        }
    }

    public synchronized Runnable addAllocationThreshold(ThresholdDirection direction, long threshold, Runnable action) {
        switch (direction) {
            case RISING: {
                return this.risingThresholds.put(threshold, action);
            }
            case FALLING: {
                return this.fallingThresholds.put(threshold, action);
            }
        }
        throw new AssertionError();
    }

    public synchronized Runnable removeAllocationThreshold(ThresholdDirection direction, long threshold) {
        switch (direction) {
            case RISING: {
                return (Runnable)this.risingThresholds.remove(threshold);
            }
            case FALLING: {
                return (Runnable)this.fallingThresholds.remove(threshold);
            }
        }
        throw new AssertionError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<ByteBuffer> allocateBackingBuffers(BufferSource source, long toAllocate, int maxChunk, int minChunk, boolean fixed) {
        long start = LOGGER.isDebugEnabled() ? System.nanoTime() : 0L;
        PrintStream allocatorLog = UpfrontAllocatingPageSource.createAllocatorLog(toAllocate, maxChunk, minChunk);
        ArrayList buffers = new ArrayList((int)(toAllocate / (long)maxChunk + 10L));
        try {
            long progressStep;
            if (allocatorLog != null) {
                allocatorLog.printf("timestamp,threadid,duration,size,physfree,totalswap,freeswap,committed%n", new Object[0]);
            }
            ArrayList<Future<Collection>> futures = new ArrayList<Future<Collection>>((int)(toAllocate / (long)maxChunk + 1L));
            ExecutorService executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
            try {
                int currentChunkSize;
                for (long dispatched = 0L; dispatched < toAllocate; dispatched += (long)currentChunkSize) {
                    currentChunkSize = (int)Math.min((long)maxChunk, toAllocate - dispatched);
                    futures.add(executorService.submit(() -> UpfrontAllocatingPageSource.bufferAllocation(source, currentChunkSize, minChunk, fixed, allocatorLog, start)));
                }
            }
            finally {
                executorService.shutdown();
            }
            long allocated = 0L;
            long nextProgressLogAt = progressStep = Math.max(PROGRESS_LOGGING_THRESHOLD, (long)((double)toAllocate * 0.1));
            for (Future future : futures) {
                Collection result = (Collection)UpfrontAllocatingPageSource.uninterruptibleGet(future);
                buffers.addAll(result);
                for (ByteBuffer buffer : result) {
                    if ((allocated += (long)buffer.capacity()) <= nextProgressLogAt) continue;
                    LOGGER.info("Allocation {}% complete", (Object)(100L * allocated / toAllocate));
                    nextProgressLogAt += progressStep;
                }
            }
        }
        finally {
            if (allocatorLog != null) {
                allocatorLog.close();
            }
        }
        if (LOGGER.isDebugEnabled()) {
            long duration = System.nanoTime() - start;
            LOGGER.debug("Took {} ms to create off-heap storage of {}B.", (Object)TimeUnit.NANOSECONDS.toMillis(duration), (Object)DebuggingUtils.toBase2SuffixedString(toAllocate));
        }
        return Collections.unmodifiableCollection(buffers);
    }

    private static Collection<ByteBuffer> bufferAllocation(BufferSource source, int toAllocate, int minChunk, boolean fixed, PrintStream allocatorLog, long start) {
        long allocated = 0L;
        long currentChunkSize = toAllocate;
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
        while (allocated < (long)toAllocate) {
            long blockStart = System.nanoTime();
            int currentAllocation = (int)Math.min(currentChunkSize, (long)toAllocate - allocated);
            ByteBuffer b = source.allocateBuffer(currentAllocation);
            long blockDuration = System.nanoTime() - blockStart;
            if (b == null) {
                if (fixed || currentChunkSize >>> 1 < (long)minChunk) {
                    throw new IllegalArgumentException("An attempt was made to allocate more off-heap memory than the JVM can allow. The limit on off-heap memory size is given by the -XX:MaxDirectMemorySize command (or equivalent).");
                }
                currentChunkSize >>>= 1;
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Allocated failed at {}B, trying  {}B chunks.", (Object)DebuggingUtils.toBase2SuffixedString(currentAllocation), (Object)DebuggingUtils.toBase2SuffixedString(currentChunkSize));
                continue;
            }
            buffers.add(b);
            allocated += (long)currentAllocation;
            if (allocatorLog != null) {
                allocatorLog.printf("%d,%d,%d,%d,%d,%d,%d,%d%n", System.nanoTime() - start, Thread.currentThread().getId(), blockDuration, currentAllocation, PhysicalMemory.freePhysicalMemory(), PhysicalMemory.totalSwapSpace(), PhysicalMemory.freeSwapSpace(), PhysicalMemory.ourCommittedVirtualMemory());
            }
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("{}B chunk allocated", (Object)DebuggingUtils.toBase2SuffixedString(currentAllocation));
        }
        return buffers;
    }

    private static <T> T uninterruptibleGet(Future<T> future) {
        boolean interrupted = Thread.interrupted();
        while (true) {
            try {
                T t = future.get();
                return t;
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RuntimeException(e);
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static PrintStream createAllocatorLog(long max, int maxChunk, int minChunk) {
        PrintStream allocatorLogStream;
        String path = System.getProperty(ALLOCATION_LOG_LOCATION);
        if (path == null) {
            return null;
        }
        try {
            File allocatorLogFile = File.createTempFile("allocation", ".csv", new File(path));
            allocatorLogStream = new PrintStream(allocatorLogFile, "US-ASCII");
        }
        catch (IOException e) {
            LOGGER.warn("Exception creating allocation log", (Throwable)e);
            return null;
        }
        allocatorLogStream.printf("Timestamp: %s%n", new Date());
        allocatorLogStream.printf("Allocating: %sB%n", DebuggingUtils.toBase2SuffixedString(max));
        allocatorLogStream.printf("Max Chunk: %sB%n", DebuggingUtils.toBase2SuffixedString(maxChunk));
        allocatorLogStream.printf("Min Chunk: %sB%n", DebuggingUtils.toBase2SuffixedString(minChunk));
        return allocatorLogStream;
    }

    static class AllocatedRegion {
        private final int address;
        private final int size;

        AllocatedRegion(int address, int size) {
            this.address = address;
            this.size = size;
        }
    }

    public static enum ThresholdDirection {
        RISING,
        FALLING;

    }
}

