/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.PublicKey;
import org.apache.xml.security.exceptions.DERDecodingException;
import org.apache.xml.security.utils.KeyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DERDecoderUtils {
    private static final Logger LOG = LoggerFactory.getLogger((String)DERDecoderUtils.class.getName());
    public static final byte TYPE_BIT_STRING = 3;
    public static final byte TYPE_OCTET_STRING = 4;
    public static final byte TYPE_SEQUENCE = 48;
    public static final byte TYPE_OBJECT_IDENTIFIER = 6;

    public static byte[] getAlgorithmIdBytes(InputStream derEncodedIS) throws DERDecodingException, IOException {
        if (derEncodedIS == null || derEncodedIS.available() <= 0) {
            throw new DERDecodingException("DER decoding error: Null data");
        }
        DERDecoderUtils.validateType(derEncodedIS.read(), (byte)48);
        DERDecoderUtils.readLength(derEncodedIS);
        DERDecoderUtils.validateType(derEncodedIS.read(), (byte)48);
        DERDecoderUtils.readLength(derEncodedIS);
        return DERDecoderUtils.readObjectIdentifier(derEncodedIS);
    }

    public static byte[] readObjectIdentifier(InputStream derEncodedIS) throws DERDecodingException {
        try {
            DERDecoderUtils.validateType(derEncodedIS.read(), (byte)6);
            int length = DERDecoderUtils.readLength(derEncodedIS);
            LOG.debug("DER decoding algorithm id bytes");
            byte[] oidBytes = new byte[length];
            derEncodedIS.read(oidBytes);
            return oidBytes;
        }
        catch (IOException ex) {
            throw new DERDecodingException("Error occurred while reading the input stream.", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getAlgorithmIdFromPublicKey(PublicKey publicKey) throws DERDecodingException {
        String keyFormat = publicKey.getFormat();
        if (!"X.509".equalsIgnoreCase(keyFormat) && !"X509".equalsIgnoreCase(keyFormat)) {
            throw new DERDecodingException("Unknown key format [" + keyFormat + "]! Support for X.509-encoded public keys only!");
        }
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(publicKey.getEncoded());){
            byte[] keyAlgOidBytes = DERDecoderUtils.getAlgorithmIdBytes(inputStream);
            String alg = DERDecoderUtils.decodeOID(keyAlgOidBytes);
            if (alg.equals(KeyUtils.KeyAlgorithmType.EC.getOid())) {
                keyAlgOidBytes = DERDecoderUtils.readObjectIdentifier(inputStream);
                alg = DERDecoderUtils.decodeOID(keyAlgOidBytes);
            }
            String string = alg;
            return string;
        }
        catch (IOException ex) {
            throw new DERDecodingException("Error reading public key", ex);
        }
    }

    private static void validateType(int iType, byte expectedType) throws DERDecodingException {
        DERDecoderUtils.validateType((byte)(iType & 0xFF), expectedType);
    }

    private static void validateType(byte type, byte expectedType) throws DERDecodingException {
        if (type != expectedType) {
            throw new DERDecodingException("DER decoding error: Expected type [" + expectedType + "] but got [" + type + "]");
        }
    }

    public static int readLength(InputStream derEncodedIs) throws DERDecodingException, IOException {
        if (derEncodedIs.available() <= 0) {
            throw new DERDecodingException("Invalid DER format");
        }
        int value = derEncodedIs.read();
        if ((value & 0x80) == 0) {
            return value;
        }
        int byteCount = value & 0x7F;
        if (byteCount == 0) {
            return -1;
        }
        if (byteCount > 4) {
            throw new DERDecodingException("Data length byte size: [" + byteCount + "] is incorrect/too big");
        }
        byte[] intSizeBytes = new byte[byteCount];
        derEncodedIs.read(intSizeBytes);
        return new BigInteger(1, intSizeBytes).intValue();
    }

    public static String decodeOID(byte[] oidBytes) {
        int length = oidBytes.length;
        StringBuilder sb = new StringBuilder(length * 4);
        int fromPos = 0;
        for (int i = 0; i < length; ++i) {
            if ((oidBytes[i] & 0x80) != 0) continue;
            long decodedValue = DERDecoderUtils.decodeBytes(oidBytes, fromPos, i - fromPos + 1);
            if (fromPos == 0) {
                if (decodedValue < 80L) {
                    sb.append(decodedValue / 40L);
                    decodedValue %= 40L;
                } else {
                    sb.append('2');
                    decodedValue -= 80L;
                }
            }
            sb.append('.');
            sb.append(decodedValue);
            fromPos = i + 1;
        }
        return sb.toString();
    }

    private static long decodeBytes(byte[] inBytes, int iOffset, int iLength) {
        if (iLength > 8) {
            throw new IllegalArgumentException("OID segment too long to parse: [" + iLength + "]");
        }
        if (iLength > 1) {
            int iSteps = iLength - 1;
            return ((long)(inBytes[iOffset] & 0x7F) << 7 * iSteps) + DERDecoderUtils.decodeBytes(inBytes, iOffset + 1, iSteps);
        }
        return inBytes[iOffset] & 0x7F;
    }
}

