/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.aot;

import java.util.LinkedHashMap;
import org.springframework.beans.factory.aot.BeanDefinitionMethodGenerator;
import org.springframework.beans.factory.aot.BeanDefinitionMethodGeneratorFactory;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotProcessor;
import org.springframework.beans.factory.aot.BeanRegistrationKey;
import org.springframework.beans.factory.aot.BeanRegistrationsAotContribution;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.lang.Nullable;

class BeanRegistrationsAotProcessor
implements BeanFactoryInitializationAotProcessor {
    BeanRegistrationsAotProcessor() {
    }

    @Override
    @Nullable
    public BeanRegistrationsAotContribution processAheadOfTime(ConfigurableListableBeanFactory beanFactory) {
        BeanDefinitionMethodGeneratorFactory beanDefinitionMethodGeneratorFactory = new BeanDefinitionMethodGeneratorFactory(beanFactory);
        LinkedHashMap<BeanRegistrationKey, BeanRegistrationsAotContribution.Registration> registrations = new LinkedHashMap<BeanRegistrationKey, BeanRegistrationsAotContribution.Registration>();
        for (String beanName : beanFactory.getBeanDefinitionNames()) {
            RegisteredBean registeredBean = RegisteredBean.of(beanFactory, beanName);
            BeanDefinitionMethodGenerator beanDefinitionMethodGenerator = beanDefinitionMethodGeneratorFactory.getBeanDefinitionMethodGenerator(registeredBean);
            if (beanDefinitionMethodGenerator == null) continue;
            registrations.put(new BeanRegistrationKey(beanName, registeredBean.getBeanClass()), new BeanRegistrationsAotContribution.Registration(beanDefinitionMethodGenerator, beanFactory.getAliases(beanName)));
        }
        if (registrations.isEmpty()) {
            return null;
        }
        return new BeanRegistrationsAotContribution(registrations);
    }
}

