/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.shadow.org.terracotta.utilities.io;

import java.io.IOException;
import java.io.OutputStream;

public class NullOutputStream
extends OutputStream {
    private volatile boolean closed = false;

    @Override
    public void write(int b) throws IOException {
        this.checkClosed();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int arrayLength = b.length;
        if ((arrayLength | off | len) < 0 || len > arrayLength - off) {
            throw new IndexOutOfBoundsException();
        }
        this.checkClosed();
    }

    @Override
    public void close() {
        this.closed = true;
    }

    private void checkClosed() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
    }
}

