/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import org.apache.cxf.rs.security.jose.jwe.JweHeaders;

public class JweEncryptionInput {
    private JweHeaders jweHeaders;
    private byte[] cek;
    private byte[] iv;
    private byte[] aad;
    private byte[] content;
    private boolean contentEncryptionRequired = true;

    public JweEncryptionInput() {
    }

    public JweEncryptionInput(JweHeaders jweHeaders) {
        this(jweHeaders, null);
    }

    public JweEncryptionInput(JweHeaders jweHeaders, byte[] content) {
        this(jweHeaders, content, null);
    }

    public JweEncryptionInput(JweHeaders jweHeaders, byte[] content, byte[] aad) {
        this(jweHeaders, content, aad, null, null);
    }

    public JweEncryptionInput(JweHeaders jweHeaders, byte[] content, byte[] cek, byte[] iv) {
        this(jweHeaders, content, null, cek, iv);
    }

    public JweEncryptionInput(JweHeaders jweHeaders, byte[] content, byte[] aad, byte[] cek, byte[] iv) {
        this.jweHeaders = jweHeaders;
        this.content = content;
        this.cek = cek;
        this.iv = iv;
        this.aad = aad;
    }

    public JweHeaders getJweHeaders() {
        return this.jweHeaders;
    }

    public void setJweHeaders(JweHeaders jweHeaders) {
        this.jweHeaders = jweHeaders;
    }

    public byte[] getCek() {
        return this.cek;
    }

    public void setCek(byte[] cek) {
        this.cek = cek;
    }

    public byte[] getIv() {
        return this.iv;
    }

    public void setIv(byte[] iv) {
        this.iv = iv;
    }

    public byte[] getAad() {
        return this.aad;
    }

    public void setAad(byte[] aad) {
        this.aad = aad;
    }

    public byte[] getContent() {
        return this.content;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public boolean isContentEncryptionRequired() {
        return this.contentEncryptionRequired;
    }

    public void setContentEncryptionRequired(boolean required) {
        this.contentEncryptionRequired = required;
    }
}

