/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Set;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.core5.function.Supplier;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.StreamingHttpOutputMessage;
import org.springframework.http.client.AbstractClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.HttpComponentsClientHttpRequest;
import org.springframework.http.client.HttpComponentsClientHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

final class HttpComponentsStreamingClientHttpRequest
extends AbstractClientHttpRequest
implements StreamingHttpOutputMessage {
    private final HttpClient httpClient;
    private final ClassicHttpRequest httpRequest;
    private final HttpContext httpContext;
    @Nullable
    private StreamingHttpOutputMessage.Body body;

    HttpComponentsStreamingClientHttpRequest(HttpClient client, ClassicHttpRequest request, HttpContext context) {
        this.httpClient = client;
        this.httpRequest = request;
        this.httpContext = context;
    }

    @Override
    public HttpMethod getMethod() {
        return HttpMethod.valueOf(this.httpRequest.getMethod());
    }

    @Override
    public URI getURI() {
        try {
            return this.httpRequest.getUri();
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
    }

    @Override
    public void setBody(StreamingHttpOutputMessage.Body body) {
        this.assertNotExecuted();
        this.body = body;
    }

    @Override
    protected OutputStream getBodyInternal(HttpHeaders headers) {
        throw new UnsupportedOperationException("getBody not supported");
    }

    @Override
    protected ClientHttpResponse executeInternal(HttpHeaders headers) throws IOException {
        HttpComponentsClientHttpRequest.addHeaders(this.httpRequest, headers);
        if (this.body != null) {
            StreamingHttpEntity requestEntity = new StreamingHttpEntity(this.getHeaders(), this.body);
            this.httpRequest.setEntity((HttpEntity)requestEntity);
        }
        HttpResponse httpResponse = this.httpClient.execute(this.httpRequest, this.httpContext);
        Assert.isInstanceOf(ClassicHttpResponse.class, (Object)httpResponse, (String)"HttpResponse not an instance of ClassicHttpResponse");
        return new HttpComponentsClientHttpResponse((ClassicHttpResponse)httpResponse);
    }

    private static class StreamingHttpEntity
    implements HttpEntity {
        private final HttpHeaders headers;
        private final StreamingHttpOutputMessage.Body body;

        public StreamingHttpEntity(HttpHeaders headers, StreamingHttpOutputMessage.Body body) {
            this.headers = headers;
            this.body = body;
        }

        public boolean isRepeatable() {
            return false;
        }

        public boolean isChunked() {
            return false;
        }

        public long getContentLength() {
            return this.headers.getContentLength();
        }

        @Nullable
        public String getContentType() {
            return this.headers.getFirst("Content-Type");
        }

        @Nullable
        public String getContentEncoding() {
            return this.headers.getFirst("Content-Encoding");
        }

        public InputStream getContent() throws IOException, IllegalStateException {
            throw new IllegalStateException("No content available");
        }

        public void writeTo(OutputStream outputStream) throws IOException {
            this.body.writeTo(outputStream);
        }

        public boolean isStreaming() {
            return true;
        }

        @Nullable
        public Supplier<List<? extends Header>> getTrailers() {
            return null;
        }

        @Nullable
        public Set<String> getTrailerNames() {
            return null;
        }

        public void close() throws IOException {
        }
    }
}

