/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.xjc.javadoc;

import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.xml.xsom.XSAttributeUse;
import com.sun.xml.xsom.XSComponent;
import com.sun.xml.xsom.XSParticle;
import org.apache.cxf.xjc.javadoc.MethodHelper;
import org.apache.cxf.xjc.javadoc.XSComponentHelper;

public class PropertyJavadoc {
    private JCodeModel codeModel;
    private Options options;
    private ClassOutline classOutline;
    private FieldOutline fieldOutline;

    public PropertyJavadoc(JCodeModel codeModel, Options options, ClassOutline classOutline, FieldOutline fieldOutline) {
        this.codeModel = codeModel;
        this.options = options;
        this.classOutline = classOutline;
        this.fieldOutline = fieldOutline;
    }

    public void addJavadocs() {
        CPropertyInfo propertyInfo = this.fieldOutline.getPropertyInfo();
        if (propertyInfo == null) {
            return;
        }
        if (propertyInfo.javadoc.length() > 0) {
            return;
        }
        XSComponent component = this.getDocumentedComponent(propertyInfo);
        String documentation = XSComponentHelper.getDocumentation(component);
        if (documentation == null || "".equals(documentation.trim())) {
            return;
        }
        this.setJavadoc(documentation.trim());
    }

    private XSComponent getDocumentedComponent(CPropertyInfo propertyInfo) {
        XSComponent schemaComponent = propertyInfo.getSchemaComponent();
        if (schemaComponent instanceof XSParticle) {
            return ((XSParticle)schemaComponent).getTerm();
        }
        if (schemaComponent instanceof XSAttributeUse) {
            return ((XSAttributeUse)schemaComponent).getDecl();
        }
        return null;
    }

    private void setJavadoc(String documentation) {
        this.setJavadocToField(documentation);
        this.setJavadocToGetter(documentation);
        this.setSeeTagToSetter();
    }

    private void setJavadocToField(String documentation) {
        JFieldVar fieldVar = (JFieldVar)this.classOutline.implClass.fields().get(this.fieldOutline.getPropertyInfo().getName(false));
        if (fieldVar == null) {
            return;
        }
        fieldVar.javadoc().append((Object)documentation);
    }

    private void setJavadocToGetter(String documentation) {
        String getterMethod = this.getGetterMethod();
        JMethod getter = MethodHelper.findMethod(this.classOutline, getterMethod);
        JDocComment javadoc = getter.javadoc();
        if (javadoc.size() != 0) {
            documentation = "\n<p>\n" + (String)documentation;
        }
        javadoc.add(javadoc.size(), documentation);
    }

    private void setSeeTagToSetter() {
        JMethod setterMethod = MethodHelper.findMethod(this.classOutline, "set" + this.fieldOutline.getPropertyInfo().getName(true));
        if (setterMethod == null) {
            return;
        }
        setterMethod.javadoc().addXdoclet("see #" + this.getGetterMethod() + "()");
    }

    private String getGetterMethod() {
        JType type = this.fieldOutline.getRawType();
        if (this.options.enableIntrospection) {
            return (type.isPrimitive() && type.boxify().getPrimitiveType() == this.codeModel.BOOLEAN ? "is" : "get") + this.fieldOutline.getPropertyInfo().getName(true);
        }
        return (type.boxify().getPrimitiveType() == this.codeModel.BOOLEAN ? "is" : "get") + this.fieldOutline.getPropertyInfo().getName(true);
    }
}

