/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.cxf.common.util.Base64UrlUtility;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.json.basic.JsonMapObject;
import org.apache.cxf.jaxrs.json.basic.JsonMapObjectReaderWriter;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;

public class JweCompactBuilder {
    private final StringBuilder jweContentBuilder;
    private final String encodedEncryptedContent;
    private final String encodedAuthTag;

    public JweCompactBuilder(JweHeaders headers, byte[] encryptedContentEncryptionKey, byte[] cipherInitVector, byte[] encryptedContentNoTag, byte[] authenticationTag) {
        this(JweCompactBuilder.getHeadersJson(headers), encryptedContentEncryptionKey, cipherInitVector, encryptedContentNoTag, authenticationTag);
    }

    public JweCompactBuilder(String headersJson, byte[] encryptedContentEncryptionKey, byte[] cipherInitVector, byte[] encryptedContentNoTag, byte[] authenticationTag) {
        this.jweContentBuilder = JweCompactBuilder.startJweContent(new StringBuilder(), headersJson, encryptedContentEncryptionKey, cipherInitVector);
        this.encodedEncryptedContent = Base64UrlUtility.encode((byte[])encryptedContentNoTag);
        this.encodedAuthTag = Base64UrlUtility.encode((byte[])authenticationTag);
    }

    public JweCompactBuilder(JweHeaders headers, byte[] encryptedContentEncryptionKey, byte[] cipherInitVector, byte[] encryptedContentWithTag, int authTagLengthBits) {
        this.jweContentBuilder = JweCompactBuilder.startJweContent(new StringBuilder(), headers, encryptedContentEncryptionKey, cipherInitVector);
        this.encodedEncryptedContent = Base64UrlUtility.encodeChunk((byte[])encryptedContentWithTag, (int)0, (int)(encryptedContentWithTag.length - authTagLengthBits / 8));
        this.encodedAuthTag = Base64UrlUtility.encodeChunk((byte[])encryptedContentWithTag, (int)(encryptedContentWithTag.length - authTagLengthBits / 8), (int)(authTagLengthBits / 8));
    }

    public static String startJweContent(JweHeaders headers, byte[] encryptedContentEncryptionKey, byte[] cipherInitVector) {
        return JweCompactBuilder.startJweContent(new StringBuilder(), headers, encryptedContentEncryptionKey, cipherInitVector).toString();
    }

    public static StringBuilder startJweContent(StringBuilder sb, JweHeaders headers, byte[] encryptedContentEncryptionKey, byte[] cipherInitVector) {
        return JweCompactBuilder.startJweContent(sb, JweCompactBuilder.getHeadersJson(headers), encryptedContentEncryptionKey, cipherInitVector);
    }

    private static String getHeadersJson(JweHeaders headers) {
        return new JsonMapObjectReaderWriter().toJson((JsonMapObject)headers);
    }

    public static StringBuilder startJweContent(StringBuilder sb, String headersJson, byte[] encryptedContentEncryptionKey, byte[] cipherInitVector) {
        String encodedHeaders = Base64UrlUtility.encode((String)headersJson);
        String encodedContentEncryptionKey = Base64UrlUtility.encode((byte[])encryptedContentEncryptionKey);
        String encodedInitVector = Base64UrlUtility.encode((byte[])cipherInitVector);
        sb.append(encodedHeaders).append('.').append(encodedContentEncryptionKey == null ? "" : encodedContentEncryptionKey).append('.').append(encodedInitVector == null ? "" : encodedInitVector).append('.');
        return sb;
    }

    public static void startJweContent(OutputStream os, JweHeaders headers, byte[] encryptedContentEncryptionKey, byte[] cipherInitVector) throws IOException {
        byte[] jsonBytes = StringUtils.toBytesUTF8((String)JweCompactBuilder.getHeadersJson(headers));
        Base64UrlUtility.encodeAndStream((byte[])jsonBytes, (int)0, (int)jsonBytes.length, (OutputStream)os);
        byte[] dotBytes = new byte[]{46};
        os.write(dotBytes);
        Base64UrlUtility.encodeAndStream((byte[])encryptedContentEncryptionKey, (int)0, (int)encryptedContentEncryptionKey.length, (OutputStream)os);
        os.write(dotBytes);
        Base64UrlUtility.encodeAndStream((byte[])cipherInitVector, (int)0, (int)cipherInitVector.length, (OutputStream)os);
        os.write(dotBytes);
        os.flush();
    }

    public String getJweContent() {
        return this.jweContentBuilder.append(this.encodedEncryptedContent).append('.').append(this.encodedAuthTag).toString();
    }
}

