/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.persistence.impl.journal.codec;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.journal.EncodingSupport;

public class PageCountRecord
implements EncodingSupport {
    private long queueID;
    private long value;
    private long persistentSize;

    public String toString() {
        return "PageCountRecord [queueID=" + this.queueID + ", value=" + this.value + ", persistentSize=" + this.persistentSize + "]";
    }

    public PageCountRecord() {
    }

    public PageCountRecord(long queueID, long value, long persistentSize) {
        this.queueID = queueID;
        this.value = value;
        this.persistentSize = persistentSize;
    }

    public long getQueueID() {
        return this.queueID;
    }

    public long getValue() {
        return this.value;
    }

    public long getPersistentSize() {
        return this.persistentSize;
    }

    public int getEncodeSize() {
        return 24;
    }

    public void encode(ActiveMQBuffer buffer) {
        buffer.writeLong(this.queueID);
        buffer.writeLong(this.value);
        buffer.writeLong(this.persistentSize);
    }

    public void decode(ActiveMQBuffer buffer) {
        this.queueID = buffer.readLong();
        this.value = buffer.readLong();
        if (buffer.readableBytes() > 0) {
            this.persistentSize = buffer.readLong();
        }
    }
}

