/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public class NodeAnnounceMessage
extends PacketImpl {
    protected String nodeID;
    protected String backupGroupName;
    protected boolean backup;
    protected long currentEventID;
    protected TransportConfiguration connector;
    protected TransportConfiguration backupConnector;
    private String scaleDownGroupName;

    public NodeAnnounceMessage(long currentEventID, String nodeID, String backupGroupName, String scaleDownGroupName, boolean backup, TransportConfiguration tc, TransportConfiguration backupConnector) {
        super((byte)111);
        this.currentEventID = currentEventID;
        this.nodeID = nodeID;
        this.backupGroupName = backupGroupName;
        this.backup = backup;
        this.connector = tc;
        this.backupConnector = backupConnector;
        this.scaleDownGroupName = scaleDownGroupName;
    }

    public NodeAnnounceMessage() {
        super((byte)111);
    }

    public NodeAnnounceMessage(byte nodeAnnounceMessage_V2) {
        super(nodeAnnounceMessage_V2);
    }

    public String getNodeID() {
        return this.nodeID;
    }

    public String getBackupGroupName() {
        return this.backupGroupName;
    }

    public boolean isBackup() {
        return this.backup;
    }

    public TransportConfiguration getConnector() {
        return this.connector;
    }

    public TransportConfiguration getBackupConnector() {
        return this.backupConnector;
    }

    public String getScaleDownGroupName() {
        return this.scaleDownGroupName;
    }

    public long getCurrentEventID() {
        return this.currentEventID;
    }

    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeString(this.nodeID);
        buffer.writeNullableString(this.backupGroupName);
        buffer.writeBoolean(this.backup);
        buffer.writeLong(this.currentEventID);
        if (this.connector != null) {
            buffer.writeBoolean(true);
            this.connector.encode(buffer);
        } else {
            buffer.writeBoolean(false);
        }
        if (this.backupConnector != null) {
            buffer.writeBoolean(true);
            this.backupConnector.encode(buffer);
        } else {
            buffer.writeBoolean(false);
        }
        buffer.writeNullableString(this.scaleDownGroupName);
    }

    public void decodeRest(ActiveMQBuffer buffer) {
        this.nodeID = buffer.readString();
        this.backupGroupName = buffer.readNullableString();
        this.backup = buffer.readBoolean();
        this.currentEventID = buffer.readLong();
        if (buffer.readBoolean()) {
            this.connector = new TransportConfiguration();
            this.connector.decode(buffer);
        }
        if (buffer.readBoolean()) {
            this.backupConnector = new TransportConfiguration();
            this.backupConnector.decode(buffer);
        }
        this.scaleDownGroupName = buffer.readNullableString();
    }

    protected String getPacketString() {
        String baseString = super.getPacketString();
        return baseString + ", backup=" + this.backup + ", connector=" + String.valueOf(this.connector) + ", nodeID=" + this.nodeID;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.backup, this.backupConnector, this.connector, this.currentEventID, this.nodeID, this.scaleDownGroupName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof NodeAnnounceMessage)) {
            return false;
        }
        NodeAnnounceMessage other = (NodeAnnounceMessage)((Object)obj);
        return this.backup == other.backup && Objects.equals(this.backupConnector, other.backupConnector) && Objects.equals(this.connector, other.connector) && this.currentEventID == other.currentEventID && Objects.equals(this.nodeID, other.nodeID) && Objects.equals(this.scaleDownGroupName, other.scaleDownGroupName);
    }
}

