/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.lang.invoke.MethodHandles;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.LargeServerMessageImpl;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.server.ComponentConfigurationRoutingType;
import org.apache.activemq.artemis.core.server.Divert;
import org.apache.activemq.artemis.core.server.RoutingContext;
import org.apache.activemq.artemis.core.server.impl.RoutingContextImpl;
import org.apache.activemq.artemis.core.server.transformer.Transformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DivertImpl
implements Divert {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final PostOffice postOffice;
    private final SimpleString address;
    private volatile SimpleString forwardAddress;
    private volatile SimpleString[] forwardAddresses;
    private final SimpleString uniqueName;
    private final SimpleString routingName;
    private final boolean exclusive;
    private volatile Filter filter;
    private volatile Transformer transformer;
    private final StorageManager storageManager;
    private volatile ComponentConfigurationRoutingType routingType;

    public DivertImpl(SimpleString uniqueName, SimpleString address, SimpleString forwardAddress, SimpleString routingName, boolean exclusive, Filter filter, Transformer transformer, PostOffice postOffice, StorageManager storageManager, ComponentConfigurationRoutingType routingType) {
        this.address = address;
        this.setForwardAddress(forwardAddress);
        this.uniqueName = uniqueName;
        this.routingName = routingName;
        this.exclusive = exclusive;
        this.filter = filter;
        this.transformer = transformer;
        this.postOffice = postOffice;
        this.storageManager = storageManager;
        this.routingType = routingType;
    }

    @Override
    public void route(Message message, RoutingContext context) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("Routing message {} through context {}", (Object)message, (Object)context);
        }
        for (SimpleString forwardAddress : this.forwardAddresses) {
            if (logger.isTraceEnabled()) {
                logger.trace("Diverting message {} into {}", (Object)message, (Object)this);
            }
            context.setReusable(false);
            Message copy = null;
            if (!forwardAddress.equals((Object)context.getAddress(message))) {
                long id = this.storageManager.generateID();
                copy = message.copy(id);
                logger.trace("Divert {} copied message {}", (Object)this.uniqueName, (Object)copy);
                copy.referenceOriginalMessage(message, this.getUniqueName());
                copy.setAddress(forwardAddress);
                copy.setExpiration(message.getExpiration());
                copy.removeExtraBytesProperty(Message.HDR_ROUTE_TO_IDS);
                switch (this.routingType) {
                    case ANYCAST: {
                        copy.setRoutingType(RoutingType.ANYCAST);
                        break;
                    }
                    case MULTICAST: {
                        copy.setRoutingType(RoutingType.MULTICAST);
                        break;
                    }
                    case STRIP: {
                        copy.setRoutingType(null);
                        break;
                    }
                }
                if (this.transformer != null) {
                    copy = LargeServerMessageImpl.checkLargeMessage(this.transformer.transform(copy), this.storageManager);
                }
                copy.reencode();
            } else {
                copy = message;
            }
            this.postOffice.route(copy, new RoutingContextImpl(context.getTransaction()).setReusable(false).setRoutingType(copy.getRoutingType()).setServerSession(context.getServerSession()), false);
        }
    }

    @Override
    public void routeWithAck(Message message, RoutingContext context) throws Exception {
        this.route(message, context);
    }

    @Override
    public SimpleString getRoutingName() {
        return this.routingName;
    }

    @Override
    public SimpleString getUniqueName() {
        return this.uniqueName;
    }

    @Override
    public boolean isExclusive() {
        return this.exclusive;
    }

    @Override
    public SimpleString getAddress() {
        return this.address;
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public Transformer getTransformer() {
        return this.transformer;
    }

    @Override
    public SimpleString getForwardAddress() {
        return this.forwardAddress;
    }

    @Override
    public ComponentConfigurationRoutingType getRoutingType() {
        return this.routingType;
    }

    @Override
    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    @Override
    public void setTransformer(Transformer transformer) {
        this.transformer = transformer;
    }

    @Override
    public void setForwardAddress(SimpleString forwardAddress) {
        this.forwardAddress = forwardAddress;
        String[] split = forwardAddress.toString().split(",");
        SimpleString[] forwardAddresses = new SimpleString[split.length];
        for (int i = 0; i < split.length; ++i) {
            forwardAddresses[i] = SimpleString.of((String)split[i].trim());
        }
        this.forwardAddresses = forwardAddresses;
    }

    @Override
    public void setRoutingType(ComponentConfigurationRoutingType routingType) {
        this.routingType = routingType;
    }

    public String toString() {
        return "DivertImpl [routingName=" + String.valueOf(this.routingName) + ", uniqueName=" + String.valueOf(this.uniqueName) + ", forwardAddress=" + String.valueOf(this.forwardAddress) + ", exclusive=" + this.exclusive + ", filter=" + String.valueOf(this.filter) + ", transformer=" + String.valueOf(this.transformer) + "]";
    }
}

