/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;

public class QueueConfigurationUtils {
    public static void applyDefaults(QueueConfiguration config, AddressSettings as) {
        QueueConfigurationUtils.applyDynamicDefaults(config, as);
        QueueConfigurationUtils.applyStaticDefaults(config);
    }

    public static void applyDynamicDefaults(QueueConfiguration config, AddressSettings as) {
        if (config.getMaxConsumers() == null) {
            config.setMaxConsumers(as.getDefaultMaxConsumers());
        }
        if (config.isExclusive() == null) {
            config.setExclusive(as.isDefaultExclusiveQueue());
        }
        if (config.isGroupRebalance() == null) {
            config.setGroupRebalance(Boolean.valueOf(as.isDefaultGroupRebalance()));
        }
        if (config.isGroupRebalancePauseDispatch() == null) {
            config.setGroupRebalancePauseDispatch(Boolean.valueOf(as.isDefaultGroupRebalancePauseDispatch()));
        }
        if (config.getGroupBuckets() == null) {
            config.setGroupBuckets(Integer.valueOf(as.getDefaultGroupBuckets()));
        }
        if (config.getGroupFirstKey() == null) {
            config.setGroupFirstKey(as.getDefaultGroupFirstKey());
        }
        if (config.isLastValue() == null) {
            config.setLastValue(Boolean.valueOf(as.isDefaultLastValueQueue()));
        }
        if (config.getLastValueKey() == null) {
            config.setLastValueKey(as.getDefaultLastValueKey());
        }
        if (config.isNonDestructive() == null) {
            config.setNonDestructive(Boolean.valueOf(as.isDefaultNonDestructive()));
        }
        if (config.getConsumersBeforeDispatch() == null) {
            config.setConsumersBeforeDispatch(as.getDefaultConsumersBeforeDispatch());
        }
        if (config.getDelayBeforeDispatch() == null) {
            config.setDelayBeforeDispatch(as.getDefaultDelayBeforeDispatch());
        }
        if (config.getRingSize() == null) {
            config.setRingSize(Long.valueOf(as.getDefaultRingSize()));
        }
        if (config.getRoutingType() == null) {
            config.setRoutingType(as.getDefaultQueueRoutingType());
        }
        if (config.isPurgeOnNoConsumers() == null) {
            config.setPurgeOnNoConsumers(as.isDefaultPurgeOnNoConsumers());
        }
        if (config.isAutoCreateAddress() == null) {
            config.setAutoCreateAddress(as.isAutoCreateAddresses());
        }
        if (config.isAutoDelete() == null) {
            config.setAutoDelete(Boolean.valueOf(config.isConfigurationManaged() == false && (config.isAutoCreated() != false && as.isAutoDeleteQueues() != false || config.isAutoCreated() == false && as.isAutoDeleteCreatedQueues() != false)));
        }
        if (config.getAutoDeleteDelay() == null) {
            config.setAutoDeleteDelay(Long.valueOf(as.getAutoDeleteQueuesDelay()));
        }
        if (config.getAutoDeleteMessageCount() == null) {
            config.setAutoDeleteMessageCount(Long.valueOf(as.getAutoDeleteQueuesMessageCount()));
        }
    }

    public static void applyStaticDefaults(QueueConfiguration config) {
        if (config.getMaxConsumers() == null) {
            config.setMaxConsumers(Integer.valueOf(ActiveMQDefaultConfiguration.getDefaultMaxQueueConsumers()));
        }
        if (config.getRoutingType() == null) {
            config.setRoutingType(ActiveMQDefaultConfiguration.getDefaultRoutingType());
        }
        if (config.isExclusive() == null) {
            config.setExclusive(Boolean.valueOf(ActiveMQDefaultConfiguration.getDefaultExclusive()));
        }
        if (config.isNonDestructive() == null) {
            config.setNonDestructive(Boolean.valueOf(ActiveMQDefaultConfiguration.getDefaultNonDestructive()));
        }
        if (config.isPurgeOnNoConsumers() == null) {
            config.setPurgeOnNoConsumers(Boolean.valueOf(ActiveMQDefaultConfiguration.getDefaultPurgeOnNoConsumers()));
        }
        if (config.isEnabled() == null) {
            config.setEnabled(Boolean.valueOf(ActiveMQDefaultConfiguration.getDefaultEnabled()));
        }
        if (config.getConsumersBeforeDispatch() == null) {
            config.setConsumersBeforeDispatch(Integer.valueOf(ActiveMQDefaultConfiguration.getDefaultConsumersBeforeDispatch()));
        }
        if (config.getDelayBeforeDispatch() == null) {
            config.setDelayBeforeDispatch(Long.valueOf(ActiveMQDefaultConfiguration.getDefaultDelayBeforeDispatch()));
        }
        if (config.isGroupRebalance() == null) {
            config.setGroupRebalance(Boolean.valueOf(ActiveMQDefaultConfiguration.getDefaultGroupRebalance()));
        }
        if (config.isGroupRebalancePauseDispatch() == null) {
            config.setGroupRebalancePauseDispatch(Boolean.valueOf(ActiveMQDefaultConfiguration.getDefaultGroupRebalancePauseDispatch()));
        }
        if (config.getGroupBuckets() == null) {
            config.setGroupBuckets(Integer.valueOf(ActiveMQDefaultConfiguration.getDefaultGroupBuckets()));
        }
        if (config.getGroupFirstKey() == null) {
            config.setGroupFirstKey(ActiveMQDefaultConfiguration.getDefaultGroupFirstKey());
        }
        if (config.isAutoDelete() == null) {
            config.setAutoDelete(Boolean.valueOf(ActiveMQDefaultConfiguration.getDefaultQueueAutoDelete((boolean)config.isAutoCreated())));
        }
        if (config.getAutoDeleteDelay() == null) {
            config.setAutoDeleteDelay(Long.valueOf(ActiveMQDefaultConfiguration.getDefaultQueueAutoDeleteDelay()));
        }
        if (config.getAutoDeleteMessageCount() == null) {
            config.setAutoDeleteMessageCount(Long.valueOf(ActiveMQDefaultConfiguration.getDefaultQueueAutoDeleteMessageCount()));
        }
        if (config.getRingSize() == null) {
            config.setRingSize(Long.valueOf(ActiveMQDefaultConfiguration.getDefaultRingSize()));
        }
        if (config.isLastValue() == null) {
            config.setLastValue(Boolean.valueOf(ActiveMQDefaultConfiguration.getDefaultLastValue()));
        }
        if (config.getLastValueKey() == null) {
            config.setLastValueKey(ActiveMQDefaultConfiguration.getDefaultLastValueKey());
        }
        if (config.isInternal() == null) {
            config.setInternal(Boolean.valueOf(ActiveMQDefaultConfiguration.getDefaultInternal()));
        }
    }
}

