/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.activemq.artemis.core.security.CheckType;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.spi.core.security.jaas.RolePrincipal;

public class SecurityManagerUtil {
    private static final String WILDCARD = "*";

    public static Set<RolePrincipal> getPrincipalsInRole(CheckType checkType, Set<Role> roles, Class rolePrincipalClass) {
        HashSet<RolePrincipal> principals = new HashSet<RolePrincipal>();
        for (Role role : roles) {
            if (!checkType.hasRole(role)) continue;
            try {
                principals.add((RolePrincipal)SecurityManagerUtil.createGroupPrincipal(role.getName(), rolePrincipalClass));
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.failedAddRolePrincipal(e);
            }
        }
        return principals;
    }

    public static String getUserFromSubject(Subject subject, Class<? extends Principal> principalClass) {
        Iterator<? extends Principal> iterator;
        if (subject != null && (iterator = subject.getPrincipals(principalClass).iterator()).hasNext()) {
            Principal candidate = iterator.next();
            return candidate.getName();
        }
        return null;
    }

    public static Object createGroupPrincipal(String name, Class cls) throws Exception {
        Object instance;
        Class<?>[] paramTypes;
        int i;
        if (WILDCARD.equals(name)) {
            return new Principal(){

                @Override
                public String getName() {
                    return SecurityManagerUtil.WILDCARD;
                }

                @Override
                public boolean equals(Object other) {
                    return true;
                }

                @Override
                public int hashCode() {
                    return SecurityManagerUtil.WILDCARD.hashCode();
                }
            };
        }
        Object[] param = new Object[]{name};
        Constructor<?>[] constructors = cls.getConstructors();
        for (i = 0; !(i >= constructors.length || (paramTypes = constructors[i].getParameterTypes()).length != 0 && paramTypes[0].equals(String.class)); ++i) {
        }
        if (i < constructors.length) {
            instance = constructors[i].newInstance(param);
        } else {
            Class<?>[] paramTypes2;
            instance = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Method[] methods = cls.getMethods();
            i = 0;
            for (i = 0; !(i >= methods.length || (paramTypes2 = methods[i].getParameterTypes()).length != 0 && methods[i].getName().equals("setName") && paramTypes2[0].equals(String.class)); ++i) {
            }
            if (i < methods.length) {
                methods[i].invoke(instance, param);
            } else {
                throw new NoSuchMethodException();
            }
        }
        return instance;
    }

    public static boolean authorize(Subject subject, Set<Role> roles, CheckType checkType, Class rolePrincipalClass) {
        boolean authorized = false;
        if (subject != null) {
            Set<RolePrincipal> rolesWithPermission = SecurityManagerUtil.getPrincipalsInRole(checkType, roles, rolePrincipalClass);
            HashSet rolesForSubject = new HashSet();
            try {
                rolesForSubject.addAll(subject.getPrincipals(rolePrincipalClass));
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.failedToFindRolesForTheSubject(e);
            }
            if (!rolesForSubject.isEmpty() && !rolesWithPermission.isEmpty()) {
                Iterator rolesForSubjectIter = rolesForSubject.iterator();
                while (!authorized && rolesForSubjectIter.hasNext()) {
                    Iterator<RolePrincipal> rolesWithPermissionIter = rolesWithPermission.iterator();
                    Principal subjectRole = (Principal)rolesForSubjectIter.next();
                    while (!authorized && rolesWithPermissionIter.hasNext()) {
                        Principal roleWithPermission = rolesWithPermissionIter.next();
                        authorized = subjectRole.equals(roleWithPermission);
                    }
                }
            }
        }
        return authorized;
    }
}

