/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.corba.types;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.events.Attribute;
import org.apache.cxf.binding.corba.types.AbstractStartEndEventProducer;
import org.apache.cxf.binding.corba.types.CorbaHandlerUtils;
import org.apache.cxf.binding.corba.types.CorbaObjectHandler;
import org.apache.cxf.binding.corba.types.CorbaPrimitiveHandler;
import org.apache.cxf.binding.corba.types.CorbaTypeEventProducer;
import org.apache.cxf.binding.corba.types.CorbaUnionHandler;
import org.apache.cxf.binding.corba.types.SkipStartEndEventProducer;
import org.apache.cxf.binding.corba.wsdl.Union;
import org.apache.cxf.service.model.ServiceInfo;
import org.omg.CORBA.ORB;

public class CorbaUnionEventProducer
extends AbstractStartEndEventProducer {
    static final List<Attribute> IS_NIL_ATTRIBUTE_LIST = new ArrayList<Attribute>();
    private final boolean isNil;

    public CorbaUnionEventProducer(CorbaObjectHandler h, ServiceInfo sInfo, ORB o) {
        CorbaUnionHandler handler = (CorbaUnionHandler)h;
        this.serviceInfo = sInfo;
        this.orb = o;
        this.name = handler.getName();
        this.isNil = this.checkIsNil(handler);
        if (!this.isNil) {
            CorbaObjectHandler contents = handler.getValue();
            if (contents != null) {
                Union unionType = (Union)handler.getType();
                if (unionType.isSetNillable() && unionType.isNillable()) {
                    CorbaTypeEventProducer contentEventProducer = CorbaHandlerUtils.getTypeEventProducer(contents, this.serviceInfo, this.orb);
                    this.currentEventProducer = new SkipStartEndEventProducer(contentEventProducer, this.name);
                } else {
                    ArrayList<CorbaObjectHandler> list = new ArrayList<CorbaObjectHandler>();
                    list.add(contents);
                    this.iterator = list.iterator();
                }
            } else if (handler.getSimpleName().equals(handler.getIdlType().getLocalPart() + "_f")) {
                this.state = this.states.length;
            }
        }
    }

    private boolean checkIsNil(CorbaUnionHandler handler) {
        CorbaPrimitiveHandler descHandler;
        Boolean descValue;
        boolean isItNil = false;
        Union unionType = (Union)handler.getType();
        if (unionType.isSetNillable() && unionType.isNillable() && !(descValue = (Boolean)(descHandler = (CorbaPrimitiveHandler)handler.getDiscriminator()).getValue()).booleanValue()) {
            isItNil = true;
        }
        return isItNil;
    }

    @Override
    public List<Attribute> getAttributes() {
        List<Attribute> attributes = IS_NIL_ATTRIBUTE_LIST;
        if (!this.isNil) {
            attributes = super.getAttributes();
        }
        return attributes;
    }

    static {
        XMLEventFactory factory = XMLEventFactory.newInstance();
        IS_NIL_ATTRIBUTE_LIST.add(factory.createAttribute(new QName("http://www.w3.org/2001/XMLSchema-instance", "nil"), "true"));
    }
}

