/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.eventing.eventsource;

import jakarta.annotation.Resource;
import jakarta.xml.ws.WebServiceContext;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.ws.eventing.Subscribe;
import org.apache.cxf.ws.eventing.SubscribeResponse;
import org.apache.cxf.ws.eventing.backend.manager.SubscriptionManagerInterfaceForEventSources;
import org.apache.cxf.ws.eventing.backend.manager.SubscriptionTicketGrantingResponse;
import org.apache.cxf.ws.eventing.eventsource.EventSourceEndpoint;
import org.apache.cxf.ws.eventing.shared.utils.DurationAndDateUtil;

public abstract class AbstractEventSource
implements EventSourceEndpoint {
    protected static final Logger LOG = LogUtils.getLogger(AbstractEventSource.class);
    @Resource
    protected WebServiceContext context;

    @Override
    public SubscribeResponse subscribeOp(Subscribe body) {
        SubscriptionTicketGrantingResponse databaseResponse = this.getSubscriptionManagerBackend().subscribe(body.getDelivery(), body.getEndTo(), body.getExpires(), body.getFilter(), body.getFormat());
        boolean shouldConvertToDuration = body.getExpires() != null ? DurationAndDateUtil.isDuration(body.getExpires().getValue()) : true;
        return this.generateResponseMessageFor(databaseResponse, shouldConvertToDuration);
    }

    protected abstract SubscriptionManagerInterfaceForEventSources getSubscriptionManagerBackend();

    protected SubscribeResponse generateResponseMessageFor(SubscriptionTicketGrantingResponse dbResponse, boolean shouldConvertToDuration) {
        SubscribeResponse ret = new SubscribeResponse();
        ret.setSubscriptionManager(dbResponse.getSubscriptionManagerReference());
        if (shouldConvertToDuration) {
            ret.setGrantedExpires(DurationAndDateUtil.toExpirationTypeContainingDuration(dbResponse.getExpires()));
        } else {
            ret.setGrantedExpires(DurationAndDateUtil.toExpirationTypeContainingGregorianCalendar(dbResponse.getExpires()));
        }
        return ret;
    }
}

