/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.saml.sso.state;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cxf.rs.security.saml.sso.state.RequestState;
import org.apache.cxf.rs.security.saml.sso.state.ResponseState;
import org.apache.cxf.rs.security.saml.sso.state.SPStateManager;

public class MemorySPStateManager
implements SPStateManager {
    private final Map<String, RequestState> requestStateMap = new ConcurrentHashMap<String, RequestState>(16, 0.75f, 4);
    private final Map<String, ResponseState> responseStateMap = new ConcurrentHashMap<String, ResponseState>(16, 0.75f, 4);

    @Override
    public ResponseState getResponseState(String securityContextKey) {
        return this.responseStateMap.get(securityContextKey);
    }

    @Override
    public ResponseState removeResponseState(String securityContextKey) {
        return this.responseStateMap.remove(securityContextKey);
    }

    @Override
    public void setResponseState(String securityContextKey, ResponseState state) {
        this.responseStateMap.put(securityContextKey, state);
    }

    @Override
    public void setRequestState(String relayState, RequestState state) {
        this.requestStateMap.put(relayState, state);
    }

    @Override
    public RequestState removeRequestState(String relayState) {
        return this.requestStateMap.remove(relayState);
    }

    @Override
    public void close() throws IOException {
        this.requestStateMap.clear();
        this.responseStateMap.clear();
    }
}

