/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.ssl;

import java.nio.BufferOverflowException;
import java.util.ArrayList;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRejectedException;
import org.apache.mina.core.write.WriteRequest;
import org.apache.mina.filter.FilterEvent;
import org.apache.mina.filter.ssl.EncryptedWriteRequest;
import org.apache.mina.filter.ssl.SslEvent;
import org.apache.mina.filter.ssl.SslFilter;
import org.apache.mina.filter.ssl.SslHandler;

class SSLHandlerG1
extends SslHandler {
    protected static final int MAX_QUEUED_MESSAGES = 64;
    protected static final int MAX_UNACK_MESSAGES = 6;
    protected static final boolean ENABLE_SOFT_CLOSURE = true;
    protected static final boolean ENABLE_FAST_HANDSHAKE = true;
    protected static final boolean ENABLE_ASYNC_TASKS = true;
    protected boolean mHandshakeComplete = false;
    protected boolean mHandshakeStarted = false;
    protected boolean mOutboundClosing = false;
    protected boolean mOutboundLinger = false;
    protected volatile Thread mReceiveThread = null;
    protected final Deque<EncryptedWriteRequest> mWriteQueue = new ConcurrentLinkedDeque<EncryptedWriteRequest>();
    protected final Deque<IoBuffer> mReceiveQueue = new ConcurrentLinkedDeque<IoBuffer>();
    protected final Deque<FilterEvent> mEventQueue = new ConcurrentLinkedDeque<FilterEvent>();
    protected SSLException mPendingError = null;

    public SSLHandlerG1(SSLEngine sslEngine, Executor executor, IoSession session) {
        super(sslEngine, executor, session);
    }

    @Override
    public boolean isOpen() {
        return !this.mEngine.isOutboundDone();
    }

    @Override
    public boolean isConnected() {
        return this.mHandshakeComplete && this.isOpen();
    }

    @Override
    public void open(IoFilter.NextFilter next) throws SSLException {
        try {
            this.open_start(next);
            this.throw_pending_error(next);
        }
        finally {
            this.forward_writes(next);
            this.forward_events(next);
        }
    }

    protected synchronized void open_start(IoFilter.NextFilter next) throws SSLException {
        if (!this.mHandshakeStarted) {
            this.mHandshakeStarted = true;
            if (this.mEngine.getUseClientMode()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("{} open() - begin handshaking", (Object)this);
                }
                this.mEngine.beginHandshake();
                this.write_handshake(next);
            }
        }
    }

    @Override
    public void receive(IoFilter.NextFilter next, IoBuffer message) throws SSLException {
        try {
            this.receive_start(next, message);
            this.throw_pending_error(next);
        }
        finally {
            this.forward_writes(next);
            this.forward_received(next);
            this.forward_events(next);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void receive_start(IoFilter.NextFilter next, IoBuffer message) throws SSLException {
        if (this.mReceiveThread == Thread.currentThread()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{} receive() - recursion", (Object)this.toString());
            }
            this.receive_loop(next, this.mDecodeBuffer);
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{} receive() - message {}", (Object)this.toString(), (Object)message);
            }
            this.mReceiveThread = Thread.currentThread();
            IoBuffer source = this.resume_decode_buffer(message);
            try {
                this.receive_loop(next, source);
            }
            finally {
                this.suspend_decode_buffer(source);
                this.mReceiveThread = null;
            }
        }
    }

    protected void receive_loop(IoFilter.NextFilter next, IoBuffer message) throws SSLException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("{} receive_loop() - source {}", (Object)this.toString(), (Object)message);
        }
        if (this.mEngine.isInboundDone()) {
            switch (this.mEngine.getHandshakeStatus()) {
                case NEED_WRAP: {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("{} receive_loop() - handshake needs wrap, invoking write", (Object)this.toString());
                    }
                    this.write_handshake(next);
                }
            }
            if (this.mPendingError != null) {
                throw this.mPendingError;
            }
            throw new IllegalStateException("closed");
        }
        IoBuffer source = message;
        if (source.remaining() == 0) {
            return;
        }
        IoBuffer dest = this.allocate_app_buffer(source.remaining());
        SSLEngineResult result = this.mEngine.unwrap(source.buf(), dest.buf());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("{} receive_loop() - bytes-consumed {}, bytes-produced {}, status {}, handshake {}", new Object[]{this.toString(), result.bytesConsumed(), result.bytesProduced(), result.getStatus(), result.getHandshakeStatus()});
        }
        if (result.bytesProduced() == 0) {
            dest.free();
        } else {
            dest.flip();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{} receive_loop() - result {}", (Object)this.toString(), (Object)dest);
            }
            this.mReceiveQueue.add(dest);
        }
        switch (result.getHandshakeStatus()) {
            case NEED_UNWRAP: {
                if (result.bytesConsumed() == 0 || !message.hasRemaining()) break;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("{} receive_loop() - handshake needs unwrap, looping", (Object)this.toString());
                }
                this.receive_loop(next, message);
                break;
            }
            case NEED_TASK: {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("{} receive_loop() - handshake needs task, scheduling", (Object)this.toString());
                }
                this.schedule_task(next);
                break;
            }
            case NEED_WRAP: {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("{} receive_loop() - handshake needs wrap, invoking write", (Object)this.toString());
                }
                this.write_handshake(next);
                break;
            }
            case FINISHED: {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("{} receive_loop() - handshake finished, flushing queue", (Object)this.toString());
                }
                this.finish_handshake(next);
                break;
            }
            case NOT_HANDSHAKING: {
                if (result.bytesProduced() == 0 && result.bytesConsumed() == 0 || !message.hasRemaining()) break;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("{} receive_loop() - trying to decode more messages, looping", (Object)this.toString());
                }
                this.receive_loop(next, message);
            }
        }
    }

    @Override
    public void ack(IoFilter.NextFilter next, WriteRequest request) throws SSLException {
        try {
            this.ack_start(next, request);
            this.throw_pending_error(next);
        }
        finally {
            this.forward_writes(next);
            this.forward_events(next);
        }
    }

    protected synchronized void ack_start(IoFilter.NextFilter next, WriteRequest request) throws SSLException {
        if (this.mAckQueue.remove(request)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{} ack() - accepted {}", (Object)this.toString(), (Object)request);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{} ack() - checking to see if any messages can be flushed", (Object)this.toString(), (Object)request);
            }
            this.flush_start(next);
        } else if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("{} ack() - unknown message {}", (Object)this.toString(), (Object)request);
        }
    }

    @Override
    public void write(IoFilter.NextFilter next, WriteRequest request) throws SSLException, WriteRejectedException {
        try {
            this.write_start(next, request);
            this.throw_pending_error(next);
        }
        finally {
            this.forward_writes(next);
            this.forward_events(next);
        }
    }

    protected synchronized void write_start(IoFilter.NextFilter next, WriteRequest request) throws SSLException, WriteRejectedException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("{} write() - source {}", (Object)this.toString(), (Object)request);
        }
        if (this.mOutboundClosing) {
            throw new WriteRejectedException(request, "closing");
        }
        if (this.mEncodeQueue.isEmpty()) {
            if (!this.write_loop(next, request)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("{} write() - unable to write right now, saving request for later", (Object)this.toString(), (Object)request);
                }
                if (this.mEncodeQueue.size() == 64) {
                    throw new BufferOverflowException();
                }
                this.mEncodeQueue.add(request);
            }
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{} write() - unable to write right now, saving request for later", (Object)this.toString(), (Object)request);
            }
            if (this.mEncodeQueue.size() == 64) {
                throw new BufferOverflowException();
            }
            this.mEncodeQueue.add(request);
        }
    }

    protected synchronized boolean write_loop(IoFilter.NextFilter next, WriteRequest request) throws SSLException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("{} write_loop() - source {}", (Object)this.toString(), (Object)request);
        }
        IoBuffer source = (IoBuffer)IoBuffer.class.cast(request.getMessage());
        IoBuffer dest = this.allocate_encode_buffer(source.remaining());
        SSLEngineResult result = this.mEngine.wrap(source.buf(), dest.buf());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("{} write_loop() - bytes-consumed {}, bytes-produced {}, status {}, handshake {}", new Object[]{this.toString(), result.bytesConsumed(), result.bytesProduced(), result.getStatus(), result.getHandshakeStatus()});
        }
        if (result.bytesProduced() == 0) {
            dest.free();
        } else if (result.bytesConsumed() == 0) {
            EncryptedWriteRequest encrypted = new EncryptedWriteRequest((Object)dest, null);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{} write_loop() - result {}", (Object)this.toString(), (Object)encrypted);
            }
            this.mWriteQueue.add(encrypted);
        } else {
            dest.flip();
            if (source.hasRemaining()) {
                EncryptedWriteRequest encrypted = new EncryptedWriteRequest((Object)dest, null);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("{} write_loop() - result {}", (Object)this.toString(), (Object)encrypted);
                }
                this.mWriteQueue.add(encrypted);
                if (this.mWriteQueue.size() + this.mAckQueue.size() < 6) {
                    return this.write_loop(next, request);
                }
                return false;
            }
            EncryptedWriteRequest encrypted = new EncryptedWriteRequest((Object)dest, request);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{} write_loop() - result {}", (Object)this.toString(), (Object)encrypted);
            }
            this.mWriteQueue.add(encrypted);
            return true;
        }
        switch (result.getHandshakeStatus()) {
            case NEED_TASK: {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("{} write_loop() - handshake needs task, scheduling", (Object)this.toString());
                }
                this.schedule_task(next);
                break;
            }
            case NEED_WRAP: {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("{} write_loop() - handshake needs wrap, looping", (Object)this.toString());
                }
                return this.write_loop(next, request);
            }
            case FINISHED: {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("{} write_loop() - handshake finished, flushing queue", (Object)this.toString());
                }
                this.finish_handshake(next);
                return this.write_loop(next, request);
            }
        }
        return false;
    }

    protected synchronized boolean write_handshake(IoFilter.NextFilter next) throws SSLException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("{} write_handshake() - internal", (Object)this.toString());
        }
        IoBuffer source = ZERO;
        IoBuffer dest = this.allocate_encode_buffer(source.remaining());
        return this.write_handshake_loop(next, source, dest);
    }

    protected boolean write_handshake_loop(IoFilter.NextFilter next, IoBuffer source, IoBuffer dest) throws SSLException {
        boolean success;
        if (this.mOutboundClosing && this.mEngine.isOutboundDone()) {
            return false;
        }
        SSLEngineResult result = this.mEngine.wrap(source.buf(), dest.buf());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("{} write_handshake_loop() - bytes-consumed {}, bytes-produced {}, status {}, handshake {}", new Object[]{this.toString(), result.bytesConsumed(), result.bytesProduced(), result.getStatus(), result.getHandshakeStatus()});
        }
        switch (result.getHandshakeStatus()) {
            case NEED_WRAP: {
                switch (result.getStatus()) {
                    case OK: {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("{} write_handshake_loop() - handshake needs wrap, fast looping", (Object)this.toString());
                        }
                        return this.write_handshake_loop(next, source, dest);
                    }
                }
            }
        }
        boolean bl = success = dest.position() != 0;
        if (!success) {
            dest.free();
        } else {
            dest.flip();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{} write_handshake_loop() - result {}", (Object)this.toString(), (Object)dest);
            }
            EncryptedWriteRequest encrypted = new EncryptedWriteRequest((Object)dest, null);
            this.mWriteQueue.add(encrypted);
        }
        switch (result.getHandshakeStatus()) {
            case NEED_UNWRAP: {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("{} write_handshake_loop() - handshake needs unwrap, invoking receive", (Object)this.toString());
                }
                this.receive_start(next, ZERO);
                break;
            }
            case NEED_WRAP: {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("{} write_handshake_loop() - handshake needs wrap, looping", (Object)this.toString());
                }
                this.write_handshake(next);
                break;
            }
            case NEED_TASK: {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("{} write_handshake_loop() - handshake needs task, scheduling", (Object)this.toString());
                }
                this.schedule_task(next);
                break;
            }
            case FINISHED: {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("{} write_handshake_loop() - handshake finished, flushing queue", (Object)this.toString());
                }
                this.finish_handshake(next);
            }
        }
        return success;
    }

    protected synchronized void finish_handshake(IoFilter.NextFilter next) throws SSLException {
        if (!this.mHandshakeComplete) {
            this.mHandshakeComplete = true;
            this.mSession.setAttribute(SslFilter.SSL_SECURED, this.mEngine.getSession());
            this.mEventQueue.add(SslEvent.SECURED);
        }
        this.receive_start(next, ZERO);
        this.flush_start(next);
    }

    public void flush(IoFilter.NextFilter next) throws SSLException {
        try {
            this.flush_start(next);
            this.throw_pending_error(next);
        }
        finally {
            this.forward_writes(next);
            this.forward_events(next);
        }
    }

    protected synchronized void flush_start(IoFilter.NextFilter next) throws SSLException {
        if (this.mOutboundClosing && !this.mOutboundLinger) {
            return;
        }
        if (this.mEncodeQueue.size() == 0) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{} flush() - no saved messages", (Object)this.toString());
            }
            return;
        }
        WriteRequest current = null;
        while (this.mWriteQueue.size() + this.mAckQueue.size() < 6 && (current = (WriteRequest)this.mEncodeQueue.poll()) != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{} flush() - {}", (Object)this.toString(), (Object)current);
            }
            if (this.write_loop(next, current)) continue;
            this.mEncodeQueue.addFirst(current);
            break;
        }
        if (this.mOutboundClosing && this.mEncodeQueue.size() == 0) {
            this.mEngine.closeOutbound();
            this.write_handshake(next);
        }
    }

    @Override
    public void close(IoFilter.NextFilter next, boolean linger) throws SSLException {
        try {
            this.close_start(next, linger);
            this.throw_pending_error(next);
        }
        finally {
            this.forward_writes(next);
            this.forward_events(next);
        }
    }

    protected synchronized void close_start(IoFilter.NextFilter next, boolean linger) throws SSLException {
        if (this.mOutboundClosing) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("{} close() - closing session", (Object)this.toString());
        }
        if (this.mHandshakeComplete) {
            next.event(this.mSession, SslEvent.UNSECURED);
        }
        this.mOutboundLinger = linger;
        this.mOutboundClosing = true;
        if (!linger) {
            if (this.mEncodeQueue.size() != 0) {
                next.exceptionCaught(this.mSession, new WriteRejectedException(new ArrayList<WriteRequest>(this.mEncodeQueue), "closing"));
                this.mEncodeQueue.clear();
            }
            this.mEngine.closeOutbound();
            this.write_handshake(next);
        } else {
            this.flush_start(next);
        }
    }

    protected synchronized void throw_pending_error(IoFilter.NextFilter next) throws SSLException {
        SSLException sslException = this.mPendingError;
        if (sslException != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{} throw_pending_error() - throwing pending error");
            }
            this.receive_loop(next, null);
            this.mPendingError = null;
            throw sslException;
        }
    }

    protected synchronized void store_pending_error(SSLException sslException) {
        if (this.mPendingError == null) {
            this.mPendingError = sslException;
        }
    }

    protected void forward_received(IoFilter.NextFilter next) {
        IoBuffer x;
        while ((x = this.mReceiveQueue.poll()) != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{} forward_received() - received {}", (Object)this.toString(), (Object)x);
            }
            next.messageReceived(this.mSession, x);
        }
    }

    protected void forward_writes(IoFilter.NextFilter next) {
        EncryptedWriteRequest x;
        while ((x = this.mWriteQueue.poll()) != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{} forward_writes() - writing {}", (Object)this.toString(), (Object)x);
            }
            this.mAckQueue.add(x);
            next.filterWrite(this.mSession, x);
        }
    }

    protected void forward_events(IoFilter.NextFilter next) {
        FilterEvent x;
        while ((x = this.mEventQueue.poll()) != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{} forward_events() - dispatching event {}", (Object)this.toString(), (Object)x);
            }
            next.event(this.mSession, x);
        }
    }

    protected void schedule_task(IoFilter.NextFilter next) {
        if (this.mExecutor != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{} schedule_task() - scheduling task", (Object)this);
            }
            this.mExecutor.execute(() -> {
                try {
                    this.execute_task(next);
                }
                finally {
                    this.forward_writes(next);
                }
            });
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{} schedule_task() - scheduling disabled, executing inline", (Object)this);
            }
            this.execute_task(next);
        }
    }

    protected synchronized void execute_task(IoFilter.NextFilter next) {
        Runnable task;
        while ((task = this.mEngine.getDelegatedTask()) != null) {
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("{} task() - executing {}", (Object)this.toString(), (Object)task);
                }
                task.run();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("{} task() - writing handshake messages", (Object)this.toString());
                }
                this.write_handshake(next);
            }
            catch (SSLException e) {
                this.store_pending_error(e);
                try {
                    this.throw_pending_error(next);
                }
                catch (SSLException sSLException) {
                    // empty catch block
                }
                if (!LOGGER.isErrorEnabled()) continue;
                LOGGER.error("{} task() - storing error {}", (Object)this.toString(), (Object)e);
            }
        }
    }
}

