/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec.multipart;

import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.codec.multipart.DefaultPartEvents;
import org.springframework.http.codec.multipart.PartEvent;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public interface FormPartEvent
extends PartEvent {
    public String value();

    public static Mono<FormPartEvent> create(String name, String value) {
        return FormPartEvent.create(name, value, null);
    }

    public static Mono<FormPartEvent> create(String name, String value, @Nullable Consumer<HttpHeaders> headersConsumer) {
        Assert.hasLength((String)name, (String)"Name must not be empty");
        Assert.notNull((Object)value, (String)"Value must not be null");
        return Mono.fromCallable(() -> {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(new MediaType(MediaType.TEXT_PLAIN, StandardCharsets.UTF_8));
            headers.setContentDisposition(ContentDisposition.formData().name(name).build());
            if (headersConsumer != null) {
                headersConsumer.accept(headers);
            }
            return DefaultPartEvents.form(headers, value);
        });
    }
}

