/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import io.netty5.channel.Channel;
import io.netty5.handler.codec.http.HttpHeaderNames;
import io.netty5.handler.codec.http.headers.HttpCookiePair;
import io.netty5.handler.ssl.SslHandler;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLSession;
import org.apache.commons.logging.Log;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.Netty5DataBufferFactory;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpLogging;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.reactive.AbstractServerHttpRequest;
import org.springframework.http.server.reactive.DefaultSslInfo;
import org.springframework.http.server.reactive.Netty5HeadersAdapter;
import org.springframework.http.server.reactive.SslInfo;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import reactor.core.publisher.Flux;
import reactor.netty5.ChannelOperationsId;
import reactor.netty5.Connection;
import reactor.netty5.http.server.HttpServerRequest;

class ReactorNetty2ServerHttpRequest
extends AbstractServerHttpRequest {
    private static final Log logger = HttpLogging.forLogName(ReactorNetty2ServerHttpRequest.class);
    private static final AtomicLong logPrefixIndex = new AtomicLong();
    private final HttpServerRequest request;
    private final Netty5DataBufferFactory bufferFactory;

    public ReactorNetty2ServerHttpRequest(HttpServerRequest request, Netty5DataBufferFactory bufferFactory) throws URISyntaxException {
        super(HttpMethod.valueOf(request.method().name()), ReactorNetty2ServerHttpRequest.initUri(request), "", new Netty5HeadersAdapter(request.requestHeaders()));
        Assert.notNull((Object)bufferFactory, (String)"DataBufferFactory must not be null");
        this.request = request;
        this.bufferFactory = bufferFactory;
    }

    private static URI initUri(HttpServerRequest request) throws URISyntaxException {
        Assert.notNull((Object)request, (String)"HttpServerRequest must not be null");
        return new URI(ReactorNetty2ServerHttpRequest.resolveBaseUrl(request) + ReactorNetty2ServerHttpRequest.resolveRequestUri(request));
    }

    private static URI resolveBaseUrl(HttpServerRequest request) throws URISyntaxException {
        String scheme = ReactorNetty2ServerHttpRequest.getScheme(request);
        InetSocketAddress hostAddress = request.hostAddress();
        if (hostAddress != null) {
            return new URI(scheme, null, hostAddress.getHostString(), hostAddress.getPort(), null, null, null);
        }
        CharSequence charSequence = request.requestHeaders().get((CharSequence)HttpHeaderNames.HOST);
        if (charSequence != null) {
            String header = charSequence.toString();
            int portIndex = header.startsWith("[") ? header.indexOf(58, header.indexOf(93)) : header.indexOf(58);
            if (portIndex != -1) {
                try {
                    return new URI(scheme, null, header.substring(0, portIndex), Integer.parseInt(header, portIndex + 1, header.length(), 10), null, null, null);
                }
                catch (NumberFormatException ex) {
                    throw new URISyntaxException(header, "Unable to parse port", portIndex);
                }
            }
            return new URI(scheme, header, null, null);
        }
        throw new IllegalStateException("Neither local hostAddress nor HOST header available");
    }

    private static String getScheme(HttpServerRequest request) {
        return request.scheme();
    }

    private static String resolveRequestUri(HttpServerRequest request) {
        char c;
        String uri = request.uri();
        for (int i = 0; i < uri.length() && (c = uri.charAt(i)) != '/' && c != '?' && c != '#'; ++i) {
            if (c != ':' || i + 2 >= uri.length() || uri.charAt(i + 1) != '/' || uri.charAt(i + 2) != '/') continue;
            for (int j = i + 3; j < uri.length(); ++j) {
                c = uri.charAt(j);
                if (c != '/' && c != '?' && c != '#') continue;
                return uri.substring(j);
            }
            return "";
        }
        return uri;
    }

    @Override
    protected MultiValueMap<String, HttpCookie> initCookies() {
        LinkedMultiValueMap cookies = new LinkedMultiValueMap();
        for (CharSequence name : this.request.cookies().keySet()) {
            for (HttpCookiePair cookie : (Set)this.request.cookies().get(name)) {
                CharSequence cookieValue = cookie.value();
                HttpCookie httpCookie = new HttpCookie(name.toString(), cookieValue != null ? cookieValue.toString() : null);
                cookies.add((Object)name.toString(), (Object)httpCookie);
            }
        }
        return cookies;
    }

    @Override
    @Nullable
    public InetSocketAddress getLocalAddress() {
        return this.request.hostAddress();
    }

    @Override
    @Nullable
    public InetSocketAddress getRemoteAddress() {
        return this.request.remoteAddress();
    }

    @Override
    @Nullable
    protected SslInfo initSslInfo() {
        Channel channel = ((Connection)this.request).channel();
        SslHandler sslHandler = (SslHandler)channel.pipeline().get(SslHandler.class);
        if (sslHandler == null && channel.parent() != null) {
            sslHandler = (SslHandler)channel.parent().pipeline().get(SslHandler.class);
        }
        if (sslHandler != null) {
            SSLSession session = sslHandler.engine().getSession();
            return new DefaultSslInfo(session);
        }
        return null;
    }

    @Override
    public Flux<DataBuffer> getBody() {
        return this.request.receive().transferOwnership().map(arg_0 -> ((Netty5DataBufferFactory)this.bufferFactory).wrap(arg_0));
    }

    @Override
    public <T> T getNativeRequest() {
        return (T)this.request;
    }

    @Override
    @Nullable
    protected String initId() {
        HttpServerRequest httpServerRequest = this.request;
        if (httpServerRequest instanceof Connection) {
            Connection connection = (Connection)httpServerRequest;
            return connection.channel().id().asShortText() + "-" + logPrefixIndex.incrementAndGet();
        }
        return null;
    }

    @Override
    protected String initLogPrefix() {
        String id = null;
        HttpServerRequest httpServerRequest = this.request;
        if (httpServerRequest instanceof ChannelOperationsId) {
            ChannelOperationsId operationsId = (ChannelOperationsId)httpServerRequest;
            String string = id = logger.isDebugEnabled() ? operationsId.asLongText() : operationsId.asShortText();
        }
        if (id != null) {
            return id;
        }
        httpServerRequest = this.request;
        if (httpServerRequest instanceof Connection) {
            Connection connection = (Connection)httpServerRequest;
            return connection.channel().id().asShortText() + "-" + logPrefixIndex.incrementAndGet();
        }
        return this.getId();
    }
}

