/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.logic;

import java.io.IOException;
import java.io.InputStream;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.resource.Resource;
import net.shibboleth.utilities.java.support.scripting.AbstractScriptEvaluator;
import net.shibboleth.utilities.java.support.scripting.EvaluableScript;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptedBiConsumer<T, U>
extends AbstractScriptEvaluator
implements BiConsumer<T, U> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ScriptedBiConsumer.class);
    @Nullable
    private Pair<Class<T>, Class<U>> inputTypes;

    protected ScriptedBiConsumer(@Nonnull @ParameterName(name="theScript") @NotEmpty EvaluableScript theScript, @Nullable @ParameterName(name="extraInfo") @NotEmpty String extraInfo) {
        super(theScript);
        this.setLogPrefix("Scripted BiConsumer from " + extraInfo + ":");
    }

    protected ScriptedBiConsumer(@Nonnull @ParameterName(name="theScript") @NotEmpty EvaluableScript theScript) {
        super(theScript);
        this.setLogPrefix("Anonymous BiConsumer:");
    }

    @Nullable
    public Pair<Class<T>, Class<U>> getInputTypes() {
        return this.inputTypes;
    }

    public void setInputTypes(@Nullable Pair<Class<T>, Class<U>> types) {
        this.inputTypes = types != null && types.getFirst() != null && types.getSecond() != null ? types : null;
    }

    @Override
    public void accept(@Nullable T first, @Nullable U second) {
        Pair<Class<T>, Class<U>> types = this.getInputTypes();
        if (null != types) {
            if (null != first && !types.getFirst().isInstance(first)) {
                this.log.error("{} Input of type {} was not of type {}", new Object[]{this.getLogPrefix(), first.getClass(), types.getFirst()});
                return;
            }
            if (null != second && !types.getSecond().isInstance(second)) {
                this.log.error("{} Input of type {} was not of type {}", new Object[]{this.getLogPrefix(), second.getClass(), types.getSecond()});
                return;
            }
        }
        this.evaluate(first, second);
    }

    @Override
    protected void prepareContext(@Nonnull ScriptContext scriptContext, Object ... input) {
        scriptContext.setAttribute("input1", input[0], 100);
        scriptContext.setAttribute("input2", input[1], 100);
    }

    public static <T, U> ScriptedBiConsumer<T, U> resourceScript(@Nonnull @NotEmpty String engineName, @Nonnull Resource resource) throws ScriptException, IOException {
        try (InputStream is = resource.getInputStream();){
            EvaluableScript script = new EvaluableScript();
            script.setEngineName(engineName);
            script.setScript(is);
            script.initializeWithScriptException();
            ScriptedBiConsumer<T, U> scriptedBiConsumer = new ScriptedBiConsumer<T, U>(script, resource.getDescription());
            return scriptedBiConsumer;
        }
    }

    public static <T, U> ScriptedBiConsumer<T, U> resourceScript(Resource resource) throws ScriptException, IOException {
        return ScriptedBiConsumer.resourceScript("JavaScript", resource);
    }

    public static <T, U> ScriptedBiConsumer<T, U> inlineScript(@Nonnull @NotEmpty String engineName, @Nonnull @NotEmpty String scriptSource) throws ScriptException {
        EvaluableScript script = new EvaluableScript();
        script.setEngineName(engineName);
        script.setScript(scriptSource);
        script.initializeWithScriptException();
        return new ScriptedBiConsumer<T, U>(script, "Inline");
    }

    public static <T, U> ScriptedBiConsumer<T, U> inlineScript(@Nonnull @NotEmpty String scriptSource) throws ScriptException {
        EvaluableScript script = new EvaluableScript();
        script.setScript(scriptSource);
        script.initializeWithScriptException();
        return new ScriptedBiConsumer<T, U>(script, "Inline");
    }
}

