/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.shadow.org.terracotta.statistics;

import java.io.Serializable;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.ehcache.shadow.org.terracotta.statistics.StatisticType;
import org.ehcache.shadow.org.terracotta.statistics.Table;
import org.ehcache.shadow.org.terracotta.statistics.TableSkeleton;
import org.ehcache.shadow.org.terracotta.statistics.ValueStatistic;

public class TableValueStatistic
extends TableSkeleton
implements ValueStatistic<Table> {
    private static final long serialVersionUID = 1L;

    public static Builder newBuilder(String ... innerStatisticNames) {
        return new Builder(innerStatisticNames);
    }

    private TableValueStatistic(String ... innerStatisticNames) {
        super(innerStatisticNames);
    }

    @Override
    public StatisticType type() {
        return StatisticType.TABLE;
    }

    @Override
    public Table value() {
        String[] statisticNames = this.getStatisticNames();
        return Table.newBuilder(statisticNames).withRows(this.getRowLabels(), (row, rowBuilder) -> {
            ValueStatistic<? extends Serializable>[] vals = this.getStatistics((String)row);
            for (int i = 0; i < vals.length; ++i) {
                rowBuilder.setStatistic(statisticNames[i], vals[i].type(), vals[i].value());
            }
        }).build();
    }

    public static interface RowBuilder {
        public <T extends Serializable> RowBuilder registerStatistic(String var1, ValueStatistic<T> var2);
    }

    public static class Builder {
        private final TableValueStatistic stat;

        private Builder(String ... innerStatisticNames) {
            this.stat = new TableValueStatistic(innerStatisticNames);
        }

        public <T extends Serializable> Builder registerStatistic(String rowName, String statisticName, ValueStatistic<T> accessor) {
            this.stat.insert(rowName, statisticName, accessor);
            return this;
        }

        public Builder withRow(final String rowName, Consumer<RowBuilder> c) {
            c.accept(new RowBuilder(){

                @Override
                public <T extends Serializable> RowBuilder registerStatistic(String statisticName, ValueStatistic<T> accessor) {
                    stat.insert(rowName, statisticName, accessor);
                    return this;
                }
            });
            return this;
        }

        public Builder withRows(Collection<String> rowNames, BiConsumer<String, RowBuilder> c) {
            rowNames.forEach(rowName -> c.accept((String)rowName, new RowBuilder((String)rowName){
                final /* synthetic */ String val$rowName;
                {
                    this.val$rowName = string;
                }

                @Override
                public <T extends Serializable> RowBuilder registerStatistic(String statisticName, ValueStatistic<T> accessor) {
                    stat.insert(this.val$rowName, statisticName, accessor);
                    return this;
                }
            }));
            return this;
        }

        public ValueStatistic<Table> build() {
            return this.stat;
        }
    }
}

