/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.shadow.org.terracotta.statistics.derived.histogram;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Stream;
import org.ehcache.shadow.org.terracotta.statistics.derived.histogram.ExponentialHistogram;
import org.ehcache.shadow.org.terracotta.statistics.derived.histogram.Histogram;
import org.ehcache.shadow.org.terracotta.statistics.derived.histogram.ImmutableBucket;

public class BarSplittingBiasedHistogram
implements Histogram {
    private static final double DEFAULT_MAX_COEFFICIENT = 1.7;
    private static final double DEFAULT_PHI = 0.7;
    private static final int DEFAULT_EXPANSION_FACTOR = 7;
    private static final double DEFAULT_EXP_HISTOGRAM_EPSILON = 0.01;
    private final int barCount;
    private final int bucketCount;
    private final double barEpsilon;
    private final long window;
    private final double phi;
    private final double alphaPhi;
    private final double ratio;
    private final List<Bar> bars;
    private final double[] maxSizeTable;
    private long size;

    public BarSplittingBiasedHistogram(double maxCoefficient, double phi, int expansionFactor, int bucketCount, double barEpsilon, long window) {
        this.bucketCount = bucketCount;
        this.barEpsilon = barEpsilon;
        this.window = window;
        this.barCount = bucketCount * expansionFactor;
        this.bars = new ArrayList<Bar>(this.barCount);
        this.bars.add(new Bar(barEpsilon, window));
        this.phi = phi;
        this.alphaPhi = phi == 1.0 ? 1.0 / (double)bucketCount : (1.0 - phi) / (1.0 - Math.pow(phi, bucketCount));
        double rho = Math.pow(phi, 1.0 / (double)expansionFactor);
        double alphaRho = rho == 1.0 ? 1.0 / (double)this.barCount : (1.0 - rho) / (1.0 - Math.pow(rho, this.barCount));
        this.ratio = rho / (1.0 + rho);
        this.maxSizeTable = new double[this.barCount];
        for (int i = 0; i < this.barCount; ++i) {
            this.maxSizeTable[i] = maxCoefficient * alphaRho * Math.pow(rho, i);
        }
    }

    public BarSplittingBiasedHistogram(int bucketCount, long window) {
        this(1.7, 0.7, 7, bucketCount, 0.01, window);
    }

    public BarSplittingBiasedHistogram(double phi, int bucketCount, long window) {
        this(1.7, phi, 7, bucketCount, 0.01, window);
    }

    @Override
    public void event(double value, long time) {
        int barIndex = this.getBarIndex(value);
        Bar bar = this.bars.get(barIndex);
        long before = bar.count();
        bar.insert(value, time);
        long after = bar.count();
        this.size += after - before;
        if ((double)after > this.maxBarSize(barIndex)) {
            this.split(bar, barIndex);
        }
    }

    @Override
    public void expire(long time) {
        long calculatedSize = 0L;
        Iterator<Bar> it = this.bars.iterator();
        while (it.hasNext()) {
            long barSize = it.next().expire(time);
            if (barSize == 0L) {
                it.remove();
            }
            calculatedSize += barSize;
        }
        this.size = calculatedSize;
        if (this.bars.isEmpty()) {
            this.bars.add(new Bar(this.barEpsilon, this.window));
        }
    }

    public String toString() {
        return this.bars.toString();
    }

    @Override
    public List<Histogram.Bucket> getBuckets() {
        ArrayList<Histogram.Bucket> buckets = new ArrayList<Histogram.Bucket>(this.bucketCount);
        double targetSize = (double)this.size() * this.alphaPhi;
        Iterator<Bar> it = this.bars.iterator();
        Bar b = it.next();
        double minimum = b.minimum();
        double count = b.count();
        for (int i = 0; i < this.bucketCount - 1 && it.hasNext(); ++i) {
            while (count < targetSize && it.hasNext()) {
                b = it.next();
                count += (double)b.count();
            }
            double surplus = count - targetSize;
            double maximum = BarSplittingBiasedHistogram.nextUpIfEqual(minimum, b.maximum() - (b.maximum() - b.minimum()) * surplus / (double)b.count());
            buckets.add(new ImmutableBucket(minimum, maximum, targetSize));
            minimum = maximum;
            count = surplus;
            targetSize *= this.phi;
        }
        while (it.hasNext()) {
            b = it.next();
            count += (double)b.count();
        }
        buckets.add(new ImmutableBucket(minimum, BarSplittingBiasedHistogram.nextUpIfEqual(minimum, b.maximum()), count));
        return buckets;
    }

    protected static double nextUpIfEqual(double test, double value) {
        return value == test ? Math.nextUp(value) : value;
    }

    @Override
    public double getMinimum() {
        return this.bars.get(0).minimum();
    }

    @Override
    public double getMaximum() {
        return Math.nextDown(this.bars.get(this.bars.size() - 1).maximum());
    }

    @Override
    public double[] getQuantileBounds(double quantile) {
        if (quantile > 1.0 || quantile < 0.0) {
            throw new IllegalArgumentException("Invalid quantile requested: " + quantile);
        }
        return Stream.of(this.evaluateQuantileFromMin(quantile), this.evaluateQuantileFromMax(quantile)).min(Comparator.comparingDouble(bounds -> bounds[1] - bounds[0])).get();
    }

    private double[] evaluateQuantileFromMax(double quantile) {
        double[] sizeBounds = this.getSizeBounds();
        double lowThreshold = (1.0 - quantile) * sizeBounds[0];
        double highThreshold = (1.0 - quantile) * sizeBounds[1];
        double lowCount = 0.0;
        double highCount = 0.0;
        ListIterator<Bar> it = this.bars.listIterator(this.bars.size());
        while (it.hasPrevious()) {
            Bar b = it.previous();
            lowCount += (double)b.count() * (1.0 - b.epsilon());
            if (!((highCount += (double)b.count() * (1.0 + b.epsilon())) >= lowThreshold)) continue;
            double upperBound = b.maximum();
            while (lowCount < highThreshold && it.hasPrevious()) {
                b = it.previous();
                lowCount += (double)b.count() * (1.0 - b.epsilon());
            }
            return new double[]{b.minimum(), upperBound};
        }
        throw new AssertionError();
    }

    private double[] evaluateQuantileFromMin(double quantile) {
        double[] sizeBounds = this.getSizeBounds();
        double lowThreshold = quantile * sizeBounds[0];
        double highThreshold = quantile * sizeBounds[1];
        double lowCount = 0.0;
        double highCount = 0.0;
        ListIterator<Bar> it = this.bars.listIterator();
        while (it.hasNext()) {
            Bar b = it.next();
            lowCount += (double)b.count() * (1.0 - b.epsilon());
            if (!((highCount += (double)b.count() * (1.0 + b.epsilon())) >= lowThreshold)) continue;
            double lowerBound = b.minimum();
            while (lowCount < highThreshold && it.hasNext()) {
                b = it.next();
                lowCount += (double)b.count() * (1.0 - b.epsilon());
            }
            return new double[]{lowerBound, b.maximum()};
        }
        throw new AssertionError();
    }

    private double maxBarSize(int barIndex) {
        return (double)this.size() * this.maxSizeTable[barIndex];
    }

    private void split(Bar x, int xIndex) {
        int mergePoint = Integer.MAX_VALUE;
        if (this.bars.size() < this.barCount || (mergePoint = this.mergeBars()) >= 0) {
            long before = x.count();
            Bar split = x.split(this.ratio);
            this.size += x.count() + split.count() - before;
            if (xIndex < mergePoint) {
                this.bars.add(xIndex + 1, split);
            } else if (xIndex > mergePoint) {
                this.bars.add(xIndex, split);
            } else {
                throw new AssertionError((Object)"split at merge point!");
            }
        }
    }

    private int mergeBars() {
        int lowestAggregateIndex = -1;
        double lowestAggregate = Double.POSITIVE_INFINITY;
        for (int index = 0; index < this.bars.size() - 1; ++index) {
            Bar current = this.bars.get(index);
            Bar next = this.bars.get(index + 1);
            double aggregate = (double)current.count() / this.maxSizeTable[index] + (double)next.count() / this.maxSizeTable[index + 1];
            if (!(aggregate < lowestAggregate)) continue;
            lowestAggregate = aggregate;
            lowestAggregateIndex = index;
        }
        if ((double)(this.bars.get(lowestAggregateIndex).count() + this.bars.get(lowestAggregateIndex + 1).count()) < this.maxBarSize(lowestAggregateIndex)) {
            Bar upper = this.bars.remove(lowestAggregateIndex + 1);
            Bar lower = this.bars.get(lowestAggregateIndex);
            long before = lower.count() + upper.count();
            lower.merge(upper);
            this.size += lower.count() - before;
            return lowestAggregateIndex + 1;
        }
        return -1;
    }

    private int getBarIndex(double value) {
        int mid;
        int low = 0;
        int high = this.bars.size() - 1;
        do {
            Bar bar;
            if (value >= (bar = this.bars.get(mid = high + low >>> 1)).maximum()) {
                low = mid + 1;
                continue;
            }
            if (value < bar.minimum()) {
                high = mid - 1;
                continue;
            }
            return mid;
        } while (low <= high);
        return mid;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public double[] getSizeBounds() {
        return new double[]{(double)this.size * (1.0 - this.barEpsilon), (double)this.size * (1.0 + this.barEpsilon)};
    }

    List<Bar> bars() {
        return this.bars;
    }

    double alphaPhi() {
        return this.alphaPhi;
    }

    double phi() {
        return this.phi;
    }

    int bucketCount() {
        return this.bucketCount;
    }

    static final class Bar {
        private final ExponentialHistogram eh;
        private double minimum = Double.NaN;
        private double maximum = Double.NaN;

        Bar(double epsilon, long window) {
            this.eh = new ExponentialHistogram(epsilon, window);
        }

        private Bar(ExponentialHistogram eh, double minimum, double maximum) {
            this.eh = eh;
            this.minimum = minimum;
            this.maximum = maximum;
        }

        void insert(double value, long time) {
            if (!(value >= this.minimum)) {
                this.minimum = value;
            }
            if (!(value < this.maximum)) {
                this.maximum = Math.nextUp(value);
            }
            this.eh.insert(time);
        }

        long expire(long time) {
            return this.eh.expire(time);
        }

        long count() {
            return this.eh.count();
        }

        public String toString() {
            return "[" + this.minimum + " --" + this.count() + "-> " + this.maximum + "]";
        }

        Bar split(double targetRatio) {
            ExponentialHistogram split = this.eh.split(targetRatio);
            double ratio = (double)split.count() / (double)(this.eh.count() + split.count());
            double upperMinimum = this.maximum - (this.maximum - this.minimum) * ratio;
            double upperMaximum = this.maximum;
            this.maximum = upperMinimum;
            return new Bar(split, upperMinimum, upperMaximum);
        }

        void merge(Bar higher) {
            this.eh.merge(higher.eh);
            this.maximum = higher.maximum;
        }

        double minimum() {
            return this.minimum;
        }

        double maximum() {
            return this.maximum;
        }

        double epsilon() {
            return this.eh.epsilon();
        }
    }
}

