/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.persistence.impl.journal.codec;

import java.util.LinkedList;
import java.util.List;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.persistence.QueueBindingInfo;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.QueueStatusEncoding;
import org.apache.activemq.artemis.core.server.impl.QueueConfigurationUtils;

public class PersistentQueueBindingEncoding
implements EncodingSupport,
QueueBindingInfo {
    private QueueConfiguration config;
    private List<QueueStatusEncoding> queueStatusEncodings;

    public PersistentQueueBindingEncoding() {
    }

    public String toString() {
        return "PersistentQueueBindingEncoding [queueConfiguration=" + String.valueOf(this.config) + "]";
    }

    public PersistentQueueBindingEncoding(QueueConfiguration config) {
        this.config = config;
    }

    @Override
    public QueueConfiguration getQueueConfiguration() {
        return this.config;
    }

    @Override
    public void addQueueStatusEncoding(QueueStatusEncoding status) {
        if (this.queueStatusEncodings == null) {
            this.queueStatusEncodings = new LinkedList<QueueStatusEncoding>();
        }
        this.queueStatusEncodings.add(status);
    }

    @Override
    public List<QueueStatusEncoding> getQueueStatusEncodings() {
        return this.queueStatusEncodings;
    }

    public void decode(ActiveMQBuffer buffer) {
        this.config = QueueConfiguration.of((SimpleString)buffer.readSimpleString());
        this.config.setAddress(buffer.readSimpleString());
        this.config.setFilterString(buffer.readNullableSimpleString());
        String metadata = buffer.readNullableSimpleString().toString();
        if (metadata != null) {
            String[] elements;
            for (String element : elements = metadata.split(";")) {
                String[] keyValuePair = element.split("=");
                if (keyValuePair.length != 2 || !keyValuePair[0].equals("user")) continue;
                this.config.setUser(SimpleString.of((String)keyValuePair[1]));
            }
        }
        this.config.setAutoCreated(Boolean.valueOf(buffer.readBoolean()));
        if (buffer.readable()) {
            this.config.setMaxConsumers(Integer.valueOf(buffer.readInt()));
            this.config.setPurgeOnNoConsumers(Boolean.valueOf(buffer.readBoolean()));
            this.config.setRoutingType(RoutingType.getType((byte)buffer.readByte()));
        }
        if (buffer.readable()) {
            this.config.setExclusive(Boolean.valueOf(buffer.readBoolean()));
        }
        if (buffer.readable()) {
            this.config.setLastValue(Boolean.valueOf(buffer.readBoolean()));
        }
        if (buffer.readable()) {
            this.config.setConfigurationManaged(Boolean.valueOf(buffer.readBoolean()));
        }
        if (buffer.readable()) {
            this.config.setConsumersBeforeDispatch(Integer.valueOf(buffer.readInt()));
        }
        if (buffer.readable()) {
            this.config.setDelayBeforeDispatch(Long.valueOf(buffer.readLong()));
        }
        if (buffer.readable()) {
            this.config.setLastValueKey(buffer.readNullableSimpleString());
        }
        if (buffer.readable()) {
            this.config.setNonDestructive(Boolean.valueOf(buffer.readBoolean()));
        }
        if (buffer.readable()) {
            this.config.setGroupRebalance(Boolean.valueOf(buffer.readBoolean()));
        }
        if (buffer.readable()) {
            this.config.setGroupBuckets(Integer.valueOf(buffer.readInt()));
        }
        if (buffer.readable()) {
            this.config.setAutoDelete(Boolean.valueOf(buffer.readBoolean()));
        }
        if (buffer.readable()) {
            this.config.setAutoDeleteDelay(Long.valueOf(buffer.readLong()));
        }
        if (buffer.readable()) {
            this.config.setAutoDeleteMessageCount(Long.valueOf(buffer.readLong()));
        }
        if (buffer.readable()) {
            this.config.setGroupFirstKey(buffer.readNullableSimpleString());
        }
        if (buffer.readable()) {
            this.config.setRingSize(Long.valueOf(buffer.readLong()));
        }
        if (buffer.readable()) {
            this.config.setEnabled(Boolean.valueOf(buffer.readBoolean()));
        }
        if (buffer.readable()) {
            this.config.setGroupRebalancePauseDispatch(Boolean.valueOf(buffer.readBoolean()));
        }
        if (buffer.readable()) {
            this.config.setInternal(Boolean.valueOf(buffer.readBoolean()));
        }
        QueueConfigurationUtils.applyStaticDefaults(this.config);
    }

    public void encode(ActiveMQBuffer buffer) {
        buffer.writeSimpleString(this.config.getName());
        buffer.writeSimpleString(this.config.getAddress());
        buffer.writeNullableSimpleString(this.config.getFilterString());
        buffer.writeNullableSimpleString(this.createMetadata());
        buffer.writeBoolean(this.config.isAutoCreated().booleanValue());
        buffer.writeInt(this.config.getMaxConsumers().intValue());
        buffer.writeBoolean(this.config.isPurgeOnNoConsumers().booleanValue());
        buffer.writeByte(this.config.getRoutingType().getType());
        buffer.writeBoolean(this.config.isExclusive().booleanValue());
        buffer.writeBoolean(this.config.isLastValue().booleanValue());
        buffer.writeBoolean(this.config.isConfigurationManaged().booleanValue());
        buffer.writeInt(this.config.getConsumersBeforeDispatch().intValue());
        buffer.writeLong(this.config.getDelayBeforeDispatch().longValue());
        buffer.writeNullableSimpleString(this.config.getLastValueKey());
        buffer.writeBoolean(this.config.isNonDestructive().booleanValue());
        buffer.writeBoolean(this.config.isGroupRebalance().booleanValue());
        buffer.writeInt(this.config.getGroupBuckets().intValue());
        buffer.writeBoolean(this.config.isAutoDelete().booleanValue());
        buffer.writeLong(this.config.getAutoDeleteDelay().longValue());
        buffer.writeLong(this.config.getAutoDeleteMessageCount().longValue());
        buffer.writeNullableSimpleString(this.config.getGroupFirstKey());
        buffer.writeLong(this.config.getRingSize().longValue());
        buffer.writeBoolean(this.config.isEnabled().booleanValue());
        buffer.writeBoolean(this.config.isGroupRebalancePauseDispatch().booleanValue());
        buffer.writeBoolean(this.config.isInternal().booleanValue());
    }

    public int getEncodeSize() {
        return SimpleString.sizeofString((SimpleString)this.config.getName()) + SimpleString.sizeofString((SimpleString)this.config.getAddress()) + SimpleString.sizeofNullableString((SimpleString)this.config.getFilterString()) + 1 + SimpleString.sizeofNullableString((SimpleString)this.createMetadata()) + 4 + 1 + 1 + 1 + 1 + 1 + 4 + 8 + SimpleString.sizeofNullableString((SimpleString)this.config.getLastValueKey()) + 1 + 1 + 4 + 1 + 8 + 8 + SimpleString.sizeofNullableString((SimpleString)this.config.getGroupFirstKey()) + 8 + 1 + 1 + 1;
    }

    private SimpleString createMetadata() {
        StringBuilder metadata = new StringBuilder();
        if (this.config.getUser() != null) {
            metadata.append("user=").append((CharSequence)this.config.getUser()).append(";");
        }
        return SimpleString.of((String)metadata.toString());
    }
}

