/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.core.server.ServerProducer;
import org.apache.activemq.artemis.core.server.impl.ServerProducers;
import org.apache.activemq.artemis.core.server.impl.ServerSessionImpl;

public class ServerProducersImpl
implements ServerProducers {
    protected final Map<String, ServerProducer> producers = new ConcurrentHashMap<String, ServerProducer>();

    @Override
    public Map<String, ServerProducer> cloneProducers() {
        return new HashMap<String, ServerProducer>(this.producers);
    }

    @Override
    public Collection<ServerProducer> getServerProducers() {
        return new ArrayList<ServerProducer>(this.producers.values());
    }

    @Override
    public ServerProducer getServerProducer(String senderName, Message msg, ServerSessionImpl serverSession) {
        if (senderName != null) {
            return this.producers.get(senderName);
        }
        return null;
    }

    @Override
    public void put(String id, ServerProducer producer) {
        this.producers.put(id, producer);
    }

    @Override
    public void remove(String id) {
        this.producers.remove(id);
    }

    @Override
    public void clear() {
        this.producers.clear();
    }
}

