/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.spi.core.protocol;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.activemq.artemis.api.core.BaseInterceptor;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManagerFactory;

public abstract class AbstractProtocolManagerFactory<P extends BaseInterceptor>
implements ProtocolManagerFactory<P> {
    protected List<P> internalFilterInterceptors(Class<P> type, List<? extends BaseInterceptor> listIn) {
        if (listIn == null) {
            return Collections.emptyList();
        }
        CopyOnWriteArrayList<BaseInterceptor> listOut = new CopyOnWriteArrayList<BaseInterceptor>();
        for (BaseInterceptor baseInterceptor : listIn) {
            if (!type.isInstance(baseInterceptor)) continue;
            listOut.add(baseInterceptor);
        }
        return listOut;
    }

    @Override
    public void loadProtocolServices(ActiveMQServer server, List<ActiveMQComponent> services) {
    }

    @Override
    public void updateProtocolServices(ActiveMQServer server, List<ActiveMQComponent> services) throws Exception {
    }
}

