/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.transforms.implementations;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignatureByteInput;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.TransformSpi;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Element;

public class TransformXSLT
extends TransformSpi {
    static final String XSLTSpecNS = "http://www.w3.org/1999/XSL/Transform";
    static final String defaultXSLTSpecNSprefix = "xslt";
    static final String XSLTSTYLESHEET = "stylesheet";
    private static final System.Logger LOG = System.getLogger(TransformXSLT.class.getName());

    @Override
    protected String engineGetURI() {
        return "http://www.w3.org/TR/1999/REC-xslt-19991116";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput input, OutputStream baos, Element transformElement, String baseURI, boolean secureValidation) throws IOException, TransformationException {
        try {
            StreamSource stylesheet;
            Element xsltElement = XMLUtils.selectNode(transformElement.getFirstChild(), XSLTSpecNS, XSLTSTYLESHEET, 0);
            if (xsltElement == null) {
                xsltElement = XMLUtils.selectNode(transformElement.getFirstChild(), XSLTSpecNS, "transform", 0);
            }
            if (xsltElement == null) {
                Object[] exArgs = new Object[]{"xslt:stylesheet", "Transform"};
                throw new TransformationException("xml.WrongContent", exArgs);
            }
            TransformerFactory tFactory = TransformerFactory.newInstance();
            tFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
            if (secureValidation) {
                try {
                    tFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                    tFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                Transformer transformer = tFactory.newTransformer();
                DOMSource source = new DOMSource(xsltElement);
                StreamResult result = new StreamResult(os);
                transformer.transform(source, result);
                stylesheet = new StreamSource(new ByteArrayInputStream(os.toByteArray()));
            }
            Transformer transformer = tFactory.newTransformer(stylesheet);
            try {
                transformer.setOutputProperty("{http://xml.apache.org/xalan}line-separator", "\n");
            }
            catch (Exception e) {
                LOG.log(System.Logger.Level.WARNING, "Unable to set Xalan line-separator property: " + e.getMessage());
            }
            try (ByteArrayInputStream is = new ByteArrayInputStream(input.getBytes());){
                StreamSource xmlSource = new StreamSource(is);
                if (baos == null) {
                    try (ByteArrayOutputStream baos1 = new ByteArrayOutputStream();){
                        StreamResult outputTarget = new StreamResult(baos1);
                        transformer.transform(xmlSource, outputTarget);
                        XMLSignatureByteInput output = new XMLSignatureByteInput(baos1.toByteArray());
                        output.setSecureValidation(secureValidation);
                        XMLSignatureByteInput xMLSignatureByteInput = output;
                        return xMLSignatureByteInput;
                    }
                }
                StreamResult outputTarget = new StreamResult(baos);
                transformer.transform(xmlSource, outputTarget);
            }
            XMLSignatureByteInput output = new XMLSignatureByteInput(null);
            output.setSecureValidation(secureValidation);
            output.setOutputStream(baos);
            return output;
        }
        catch (TransformerException | XMLSecurityException ex) {
            throw new TransformationException(ex);
        }
    }
}

