/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.os;

import io.smallrye.common.os.GetAllProcessesInfoAction;
import io.smallrye.common.os.ProcessInfo;
import java.security.AccessController;
import java.util.List;

public final class Process {
    private Process() {
    }

    public static String getProcessName() {
        return AccessController.doPrivileged(Process::computeProcessName);
    }

    private static String computeProcessName() {
        ProcessHandle processHandle = ProcessHandle.current();
        String processName = System.getProperty("jboss.process.name");
        if (processName == null) {
            processName = processHandle.info().command().orElse(null);
        }
        if (processName == null) {
            processName = "<unknown>";
        }
        return processName;
    }

    @Deprecated(since="2.4", forRemoval=true)
    public static long getProcessId() {
        return Process.currentProcess().pid();
    }

    @Deprecated(since="2.4", forRemoval=true)
    public static ProcessInfo getCurrentProcess() {
        return new ProcessInfo(Process.currentProcess().pid(), Process.getProcessName());
    }

    private static ProcessHandle currentProcess() {
        return AccessController.doPrivileged(ProcessHandle::current);
    }

    @Deprecated(since="2.4", forRemoval=true)
    public static List<ProcessInfo> getAllProcesses() {
        return AccessController.doPrivileged(new GetAllProcessesInfoAction());
    }
}

