/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.grants.code;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityNotFoundException;
import jakarta.persistence.TypedQuery;
import java.util.List;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.grants.code.AbstractCodeDataProvider;
import org.apache.cxf.rs.security.oauth2.grants.code.AuthorizationCodeDataProvider;
import org.apache.cxf.rs.security.oauth2.grants.code.AuthorizationCodeRegistration;
import org.apache.cxf.rs.security.oauth2.grants.code.ServerAuthorizationCodeGrant;
import org.apache.cxf.rs.security.oauth2.provider.JPAOAuthDataProvider;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;

public class JPACodeDataProvider
extends JPAOAuthDataProvider
implements AuthorizationCodeDataProvider {
    private long codeLifetime = 600L;

    @Override
    public ServerAuthorizationCodeGrant createCodeGrant(AuthorizationCodeRegistration reg) throws OAuthServiceException {
        ServerAuthorizationCodeGrant grant = this.doCreateCodeGrant(reg);
        this.saveCodeGrant(grant);
        return grant;
    }

    protected ServerAuthorizationCodeGrant doCreateCodeGrant(AuthorizationCodeRegistration reg) throws OAuthServiceException {
        return AbstractCodeDataProvider.initCodeGrant(reg, this.codeLifetime);
    }

    protected void saveCodeGrant(ServerAuthorizationCodeGrant grant) {
        this.executeInTransaction(em -> {
            if (grant.getSubject() != null) {
                UserSubject sub = (UserSubject)em.find(UserSubject.class, (Object)grant.getSubject().getId());
                if (sub == null) {
                    em.persist((Object)grant.getSubject());
                } else {
                    sub = (UserSubject)em.merge((Object)grant.getSubject());
                    grant.setSubject(sub);
                }
            }
            if (grant.getClient() != null) {
                grant.setClient((Client)em.find(Client.class, (Object)grant.getClient().getClientId()));
            }
            em.persist((Object)grant);
            return null;
        });
    }

    @Override
    protected void doRemoveClient(Client c) {
        this.executeInTransaction(em -> {
            this.removeClientCodeGrants(c, (EntityManager)em);
            Client clientToRemove = (Client)em.getReference(Client.class, (Object)c.getClientId());
            em.remove((Object)clientToRemove);
            return null;
        });
    }

    protected void removeClientCodeGrants(Client c) {
        this.executeInTransaction(em -> {
            this.removeClientCodeGrants(c, (EntityManager)em);
            return null;
        });
    }

    protected void removeClientCodeGrants(Client c, EntityManager em) {
        for (ServerAuthorizationCodeGrant grant : this.getCodeGrants(c, null, em)) {
            this.removeCodeGrant(grant.getCode(), em);
        }
    }

    @Override
    public ServerAuthorizationCodeGrant removeCodeGrant(String code) throws OAuthServiceException {
        return (ServerAuthorizationCodeGrant)this.executeInTransaction(em -> this.removeCodeGrant(code, (EntityManager)em));
    }

    private ServerAuthorizationCodeGrant removeCodeGrant(String code, EntityManager em) throws OAuthServiceException {
        ServerAuthorizationCodeGrant grant = (ServerAuthorizationCodeGrant)em.find(ServerAuthorizationCodeGrant.class, (Object)code);
        try {
            if (grant != null) {
                em.remove((Object)grant);
            }
        }
        catch (EntityNotFoundException entityNotFoundException) {
            // empty catch block
        }
        return grant;
    }

    @Override
    public List<ServerAuthorizationCodeGrant> getCodeGrants(Client c, UserSubject subject) throws OAuthServiceException {
        return (List)this.executeInTransaction(em -> this.getCodeGrants(c, subject, (EntityManager)em));
    }

    private List<ServerAuthorizationCodeGrant> getCodeGrants(Client c, UserSubject subject, EntityManager em) throws OAuthServiceException {
        return this.getCodesQuery(c, subject, em).getResultList();
    }

    public void setCodeLifetime(long codeLifetime) {
        this.codeLifetime = codeLifetime;
    }

    protected TypedQuery<ServerAuthorizationCodeGrant> getCodesQuery(Client c, UserSubject resourceOwnerSubject, EntityManager em) {
        if (c == null && resourceOwnerSubject == null) {
            return em.createQuery("SELECT c FROM ServerAuthorizationCodeGrant c", ServerAuthorizationCodeGrant.class);
        }
        if (c == null && resourceOwnerSubject != null) {
            return em.createQuery("SELECT c FROM ServerAuthorizationCodeGrant c JOIN c.subject s WHERE s.login = :login", ServerAuthorizationCodeGrant.class).setParameter("login", (Object)resourceOwnerSubject.getLogin());
        }
        if (c != null && resourceOwnerSubject == null) {
            return em.createQuery("SELECT code FROM ServerAuthorizationCodeGrant code JOIN code.client c WHERE c.clientId = :clientId", ServerAuthorizationCodeGrant.class).setParameter("clientId", (Object)c.getClientId());
        }
        return em.createQuery("SELECT code FROM ServerAuthorizationCodeGrant code JOIN code.subject s JOIN code.client c WHERE s.login = :login AND c.clientId = :clientId", ServerAuthorizationCodeGrant.class).setParameter("clientId", (Object)c.getClientId()).setParameter("login", (Object)resourceOwnerSubject.getLogin());
    }
}

