/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.server.config.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.utils.BufferHelper;

public class TransportConfigurationEncodingSupport {
    public static List<Pair<TransportConfiguration, TransportConfiguration>> decodeConfigs(ActiveMQBuffer buffer) {
        int size = buffer.readInt();
        ArrayList<Pair<TransportConfiguration, TransportConfiguration>> configs = new ArrayList<Pair<TransportConfiguration, TransportConfiguration>>(size);
        for (int i = 0; i < size; ++i) {
            TransportConfiguration primary = TransportConfigurationEncodingSupport.decode(buffer);
            boolean hasBackup = buffer.readBoolean();
            TransportConfiguration backup = null;
            if (hasBackup) {
                backup = TransportConfigurationEncodingSupport.decode(buffer);
            }
            configs.add((Pair<TransportConfiguration, TransportConfiguration>)new Pair((Object)primary, (Object)backup));
        }
        return configs;
    }

    public static TransportConfiguration decode(ActiveMQBuffer buffer) {
        String name = BufferHelper.readNullableSimpleStringAsString((ActiveMQBuffer)buffer);
        String factoryClassName = buffer.readSimpleString().toString();
        int paramSize = buffer.readInt();
        HashMap<String, String> params = new HashMap<String, String>();
        for (int i = 0; i < paramSize; ++i) {
            String key = buffer.readSimpleString().toString();
            String value = buffer.readSimpleString().toString();
            params.put(key, value);
        }
        TransportConfiguration config = new TransportConfiguration(factoryClassName, params, name);
        return config;
    }

    public static void encodeConfigs(ActiveMQBuffer buffer, List<Pair<TransportConfiguration, TransportConfiguration>> configs) {
        buffer.writeInt(configs == null ? 0 : configs.size());
        if (configs != null) {
            for (Pair<TransportConfiguration, TransportConfiguration> pair : configs) {
                TransportConfigurationEncodingSupport.encode(buffer, (TransportConfiguration)pair.getA());
                boolean backup = pair.getB() != null;
                buffer.writeBoolean(backup);
                if (!backup) continue;
                TransportConfigurationEncodingSupport.encode(buffer, (TransportConfiguration)pair.getB());
            }
        }
    }

    public static void encode(ActiveMQBuffer buffer, TransportConfiguration config) {
        BufferHelper.writeAsNullableSimpleString((ActiveMQBuffer)buffer, (String)config.getName());
        BufferHelper.writeAsSimpleString((ActiveMQBuffer)buffer, (String)config.getFactoryClassName());
        buffer.writeInt(config.getParams().size());
        for (Map.Entry param : config.getParams().entrySet()) {
            BufferHelper.writeAsSimpleString((ActiveMQBuffer)buffer, (String)((String)param.getKey()));
            BufferHelper.writeAsSimpleString((ActiveMQBuffer)buffer, (String)param.getValue().toString());
        }
    }

    public static int getEncodeSize(TransportConfiguration config) {
        int size = BufferHelper.sizeOfNullableSimpleString((String)config.getName()) + BufferHelper.sizeOfSimpleString((String)config.getFactoryClassName());
        size += 4;
        for (Map.Entry param : config.getParams().entrySet()) {
            size += BufferHelper.sizeOfSimpleString((String)((String)param.getKey()));
            size += BufferHelper.sizeOfSimpleString((String)param.getValue().toString());
        }
        return size;
    }

    public static int getEncodeSize(List<Pair<TransportConfiguration, TransportConfiguration>> configs) {
        int size = 4;
        if (configs != null) {
            for (Pair<TransportConfiguration, TransportConfiguration> pair : configs) {
                size += TransportConfigurationEncodingSupport.getEncodeSize((TransportConfiguration)pair.getA());
                ++size;
                if (pair.getB() == null) continue;
                size += TransportConfigurationEncodingSupport.getEncodeSize((TransportConfiguration)pair.getB());
            }
        }
        return size;
    }
}

