/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.profile.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.xml.SerializeSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.MessageLookup;
import org.opensaml.profile.action.AbstractProfileAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.OutboundMessageContextLookup;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml1.core.Assertion;
import org.opensaml.saml.saml1.core.Response;
import org.opensaml.saml.saml2.core.ArtifactResponse;
import org.opensaml.security.SecurityException;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.opensaml.xmlsec.signature.SignableXMLObject;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.SignatureSupport;
import org.slf4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SignAssertions
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SignAssertions.class);
    @Nonnull
    private Function<ProfileRequestContext, SAMLObject> responseLookupStrategy = new MessageLookup(SAMLObject.class).compose((Function)new OutboundMessageContextLookup());
    @Nonnull
    private Function<ProfileRequestContext, SecurityParametersContext> securityParametersLookupStrategy = new ChildContextLookup(SecurityParametersContext.class);
    @NonnullBeforeExec
    private SignatureSigningParameters signatureSigningParameters;
    @NonnullBeforeExec
    private SAMLObject response;

    public void setResponseLookupStrategy(@Nonnull Function<ProfileRequestContext, SAMLObject> strategy) {
        this.checkSetterPreconditions();
        this.responseLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Response lookup strategy cannot be null");
    }

    public void setSecurityParametersLookupStrategy(@Nonnull Function<ProfileRequestContext, SecurityParametersContext> strategy) {
        this.checkSetterPreconditions();
        this.securityParametersLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SecurityParameterContext lookup strategy cannot be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        SecurityParametersContext secParamCtx;
        SAMLObject sAMLObject;
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.response = this.responseLookupStrategy.apply(profileRequestContext);
        if (this.response == null) {
            this.log.debug("{} No SAML Response located in current profile request context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        SAMLObject sAMLObject2 = this.response;
        if (sAMLObject2 instanceof ArtifactResponse) {
            ArtifactResponse resp = (ArtifactResponse)sAMLObject2;
            this.log.debug("{} Found ArtifactResponse, stepping down into enclosed message", (Object)this.getLogPrefix());
            this.response = resp.getMessage();
        }
        if ((sAMLObject = this.response) instanceof Response) {
            Response saml1 = (Response)sAMLObject;
            if (saml1.getAssertions().isEmpty()) {
                this.log.debug("{} No assertions available, nothing to do", (Object)this.getLogPrefix());
                return false;
            }
        } else {
            sAMLObject = this.response;
            if (sAMLObject instanceof org.opensaml.saml.saml2.core.Response) {
                org.opensaml.saml.saml2.core.Response saml2 = (org.opensaml.saml.saml2.core.Response)sAMLObject;
                if (saml2.getAssertions().isEmpty()) {
                    this.log.debug("{} No assertions available, nothing to do", (Object)this.getLogPrefix());
                    return false;
                }
            } else {
                this.log.debug("{} Message returned by lookup strategy was not a SAML Response", (Object)this.getLogPrefix());
                return false;
            }
        }
        if ((secParamCtx = this.securityParametersLookupStrategy.apply(profileRequestContext)) == null) {
            this.log.debug("{} Will not sign assertions because no security parameters context is available", (Object)this.getLogPrefix());
            return false;
        }
        this.signatureSigningParameters = secParamCtx.getSignatureSigningParameters();
        if (this.signatureSigningParameters == null) {
            this.log.debug("{} Will not sign assertions because no signature signing parameters available", (Object)this.getLogPrefix());
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        try {
            Object object;
            if (this.log.isTraceEnabled()) {
                this.logResponse("Response before signing:");
            }
            if ((object = this.response) instanceof Response) {
                Response saml1 = (Response)object;
                for (Assertion assertion : saml1.getAssertions()) {
                    assert (assertion != null);
                    SignatureSupport.signObject((SignableXMLObject)assertion, (SignatureSigningParameters)this.signatureSigningParameters);
                }
            } else {
                object = this.response;
                if (object instanceof org.opensaml.saml.saml2.core.Response) {
                    org.opensaml.saml.saml2.core.Response saml2 = (org.opensaml.saml.saml2.core.Response)object;
                    for (org.opensaml.saml.saml2.core.Assertion assertion : saml2.getAssertions()) {
                        assert (assertion != null);
                        SignatureSupport.signObject((SignableXMLObject)assertion, (SignatureSigningParameters)this.signatureSigningParameters);
                    }
                }
            }
            if (this.log.isTraceEnabled()) {
                this.logResponse("Response after signing:");
            }
        }
        catch (MarshallingException | SecurityException | SignatureException e) {
            this.log.warn("{} Error encountered while signing assertions", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"UnableToSign");
        }
    }

    private void logResponse(@Nonnull String message) {
        if (message != null && this.response != null) {
            try {
                Element dom = XMLObjectSupport.marshall((XMLObject)this.response);
                this.log.trace(message + "\n" + SerializeSupport.prettyPrintXML((Node)dom));
            }
            catch (MarshallingException e) {
                this.log.warn("Unable to marshall message for logging purposes", (Throwable)e);
            }
        }
    }
}

