/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml1.core.impl;

import java.time.Instant;
import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import net.shibboleth.shared.xml.AttributeSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.common.AbstractSAMLObjectMarshaller;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.saml1.core.RequestAbstractType;
import org.w3c.dom.Element;

public class RequestAbstractTypeMarshaller
extends AbstractSAMLObjectMarshaller {
    protected void marshallAttributes(@Nonnull XMLObject xmlObject, @Nonnull Element domElement) throws MarshallingException {
        SAMLVersion version;
        Instant i;
        RequestAbstractType request = (RequestAbstractType)xmlObject;
        if (request.getID() != null) {
            domElement.setAttributeNS(null, "RequestID", request.getID());
        }
        if ((i = request.getIssueInstant()) != null) {
            AttributeSupport.appendDateTimeAttribute((Element)domElement, (QName)RequestAbstractType.ISSUEINSTANT_ATTRIB_QNAME, (Instant)i);
        }
        if ((version = request.getVersion()) != null) {
            domElement.setAttributeNS(null, "MajorVersion", Integer.toString(version.getMajorVersion()));
            domElement.setAttributeNS(null, "MinorVersion", Integer.toString(version.getMinorVersion()));
        }
    }

    protected void marshallAttributeIDness(@Nonnull XMLObject xmlObject, @Nonnull Element domElement) throws MarshallingException {
        if (((RequestAbstractType)xmlObject).getVersion() != SAMLVersion.VERSION_10) {
            XMLObjectSupport.marshallAttributeIDness(null, (String)"RequestID", (Element)domElement, (boolean)true);
        }
    }
}

