/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.saml;

import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import java.util.List;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.rs.security.saml.AbstractSamlBase64InHandler;

public class SamlHeaderInHandler
extends AbstractSamlBase64InHandler {
    private static final String SAML_AUTH = "SAML";
    @Context
    private HttpHeaders headers;

    public void filter(ContainerRequestContext context) {
        String[] parts;
        Message message = JAXRSUtils.getCurrentMessage();
        List values = this.headers.getRequestHeader("Authorization");
        if (values == null || values.size() != 1 || !((String)values.get(0)).startsWith(SAML_AUTH)) {
            this.throwFault("Authorization header must be available and use SAML profile", null);
        }
        if ((parts = ((String)values.get(0)).split(" ")).length != 2) {
            this.throwFault("Authorization header is malformed", null);
        }
        this.handleToken(message, parts[1]);
    }
}

